/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestPortStatsBuilder
implements Builder<MultipartRequestPortStats> {
    private Long _portNo;
    Map<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>> augmentation = Collections.emptyMap();

    public MultipartRequestPortStatsBuilder() {
    }

    public MultipartRequestPortStatsBuilder(MultipartRequestPortStats base) {
        AugmentationHolder casted;
        this._portNo = base.getPortNo();
        if (base instanceof MultipartRequestPortStatsImpl) {
            MultipartRequestPortStatsImpl impl = (MultipartRequestPortStatsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>>(casted.augmentations());
        }
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public <E extends Augmentation<MultipartRequestPortStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestPortStatsBuilder setPortNo(Long value) {
        if (value != null) {
            MultipartRequestPortStatsBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    public MultipartRequestPortStatsBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestPortStats>> augmentationType, Augmentation<MultipartRequestPortStats> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestPortStatsBuilder removeAugmentation(Class<? extends Augmentation<MultipartRequestPortStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartRequestPortStats build() {
        return new MultipartRequestPortStatsImpl(this);
    }

    private static final class MultipartRequestPortStatsImpl
    implements MultipartRequestPortStats {
        private final Long _portNo;
        private Map<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartRequestPortStats> getImplementedInterface() {
            return MultipartRequestPortStats.class;
        }

        private MultipartRequestPortStatsImpl(MultipartRequestPortStatsBuilder base) {
            this._portNo = base.getPortNo();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        public <E extends Augmentation<MultipartRequestPortStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._portNo);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartRequestPortStats.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartRequestPortStats other = (MultipartRequestPortStats)obj;
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartRequestPortStatsImpl otherImpl = (MultipartRequestPortStatsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartRequestPortStats>>, Augmentation<MultipartRequestPortStats>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartRequestPortStats [");
            boolean first = true;
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

