/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueue;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestQueueBuilder
implements Builder<MultipartRequestQueue> {
    private Long _portNo;
    private Long _queueId;
    Map<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> augmentation = Collections.emptyMap();

    public MultipartRequestQueueBuilder() {
    }

    public MultipartRequestQueueBuilder(MultipartRequestQueue base) {
        AugmentationHolder casted;
        this._portNo = base.getPortNo();
        this._queueId = base.getQueueId();
        if (base instanceof MultipartRequestQueueImpl) {
            MultipartRequestQueueImpl impl = (MultipartRequestQueueImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>(casted.augmentations());
        }
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public Long getQueueId() {
        return this._queueId;
    }

    public <E extends Augmentation<MultipartRequestQueue>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestQueueBuilder setPortNo(Long value) {
        if (value != null) {
            MultipartRequestQueueBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    private static void checkQueueIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MultipartRequestQueueBuilder setQueueId(Long value) {
        if (value != null) {
            MultipartRequestQueueBuilder.checkQueueIdRange(value);
        }
        this._queueId = value;
        return this;
    }

    public MultipartRequestQueueBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestQueue>> augmentationType, Augmentation<MultipartRequestQueue> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestQueueBuilder removeAugmentation(Class<? extends Augmentation<MultipartRequestQueue>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartRequestQueue build() {
        return new MultipartRequestQueueImpl(this);
    }

    private static final class MultipartRequestQueueImpl
    implements MultipartRequestQueue {
        private final Long _portNo;
        private final Long _queueId;
        private Map<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartRequestQueue> getImplementedInterface() {
            return MultipartRequestQueue.class;
        }

        private MultipartRequestQueueImpl(MultipartRequestQueueBuilder base) {
            this._portNo = base.getPortNo();
            this._queueId = base.getQueueId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        public <E extends Augmentation<MultipartRequestQueue>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode(this._queueId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartRequestQueue.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartRequestQueue other = (MultipartRequestQueue)obj;
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartRequestQueueImpl otherImpl = (MultipartRequestQueueImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultipartRequestQueue [");
            boolean first = true;
            if (this._portNo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_portNo=");
                builder.append(this._portNo);
            }
            if (this._queueId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

