/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableFeaturesPropertiesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableFeaturesBuilder
implements Builder<TableFeatures> {
    private TableConfig _config;
    private Long _maxEntries;
    private BigInteger _metadataMatch;
    private BigInteger _metadataWrite;
    private String _name;
    private List<TableFeatureProperties> _tableFeatureProperties;
    private Short _tableId;
    Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKMETADATAMATCHRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKMETADATAWRITERANGE_RANGES;

    public TableFeaturesBuilder() {
    }

    public TableFeaturesBuilder(TableFeaturesPropertiesGrouping arg) {
        this._tableFeatureProperties = arg.getTableFeatureProperties();
    }

    public TableFeaturesBuilder(TableFeatures base) {
        AugmentationHolder casted;
        this._config = base.getConfig();
        this._maxEntries = base.getMaxEntries();
        this._metadataMatch = base.getMetadataMatch();
        this._metadataWrite = base.getMetadataWrite();
        this._name = base.getName();
        this._tableFeatureProperties = base.getTableFeatureProperties();
        this._tableId = base.getTableId();
        if (base instanceof TableFeaturesImpl) {
            TableFeaturesImpl impl = (TableFeaturesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TableFeaturesPropertiesGrouping) {
            this._tableFeatureProperties = ((TableFeaturesPropertiesGrouping)arg).getTableFeatureProperties();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableFeaturesPropertiesGrouping] \nbut was: " + arg);
        }
    }

    public TableConfig getConfig() {
        return this._config;
    }

    public Long getMaxEntries() {
        return this._maxEntries;
    }

    public BigInteger getMetadataMatch() {
        return this._metadataMatch;
    }

    public BigInteger getMetadataWrite() {
        return this._metadataWrite;
    }

    public String getName() {
        return this._name;
    }

    public List<TableFeatureProperties> getTableFeatureProperties() {
        return this._tableFeatureProperties;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableFeaturesBuilder setConfig(TableConfig value) {
        this._config = value;
        return this;
    }

    private static void checkMaxEntriesRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TableFeaturesBuilder setMaxEntries(Long value) {
        if (value != null) {
            TableFeaturesBuilder.checkMaxEntriesRange(value);
        }
        this._maxEntries = value;
        return this;
    }

    private static void checkMetadataMatchRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKMETADATAMATCHRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKMETADATAMATCHRANGE_RANGES)));
    }

    public TableFeaturesBuilder setMetadataMatch(BigInteger value) {
        if (value != null) {
            TableFeaturesBuilder.checkMetadataMatchRange(value);
        }
        this._metadataMatch = value;
        return this;
    }

    private static void checkMetadataWriteRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKMETADATAWRITERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKMETADATAWRITERANGE_RANGES)));
    }

    public TableFeaturesBuilder setMetadataWrite(BigInteger value) {
        if (value != null) {
            TableFeaturesBuilder.checkMetadataWriteRange(value);
        }
        this._metadataWrite = value;
        return this;
    }

    public TableFeaturesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TableFeaturesBuilder setTableFeatureProperties(List<TableFeatureProperties> value) {
        this._tableFeatureProperties = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableFeaturesBuilder setTableId(Short value) {
        if (value != null) {
            TableFeaturesBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public TableFeaturesBuilder addAugmentation(Class<? extends Augmentation<TableFeatures>> augmentationType, Augmentation<TableFeatures> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableFeaturesBuilder removeAugmentation(Class<? extends Augmentation<TableFeatures>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableFeatures build() {
        return new TableFeaturesImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKMETADATAMATCHRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKMETADATAWRITERANGE_RANGES = a;
    }

    private static final class TableFeaturesImpl
    implements TableFeatures {
        private final TableConfig _config;
        private final Long _maxEntries;
        private final BigInteger _metadataMatch;
        private final BigInteger _metadataWrite;
        private final String _name;
        private final List<TableFeatureProperties> _tableFeatureProperties;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableFeatures> getImplementedInterface() {
            return TableFeatures.class;
        }

        private TableFeaturesImpl(TableFeaturesBuilder base) {
            this._config = base.getConfig();
            this._maxEntries = base.getMaxEntries();
            this._metadataMatch = base.getMetadataMatch();
            this._metadataWrite = base.getMetadataWrite();
            this._name = base.getName();
            this._tableFeatureProperties = base.getTableFeatureProperties();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>(base.augmentation);
                }
            }
        }

        @Override
        public TableConfig getConfig() {
            return this._config;
        }

        @Override
        public Long getMaxEntries() {
            return this._maxEntries;
        }

        @Override
        public BigInteger getMetadataMatch() {
            return this._metadataMatch;
        }

        @Override
        public BigInteger getMetadataWrite() {
            return this._metadataWrite;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<TableFeatureProperties> getTableFeatureProperties() {
            return this._tableFeatureProperties;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._config);
            result = 31 * result + Objects.hashCode(this._maxEntries);
            result = 31 * result + Objects.hashCode(this._metadataMatch);
            result = 31 * result + Objects.hashCode(this._metadataWrite);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._tableFeatureProperties);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableFeatures.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableFeatures other = (TableFeatures)obj;
            if (!Objects.equals(this._config, other.getConfig())) {
                return false;
            }
            if (!Objects.equals(this._maxEntries, other.getMaxEntries())) {
                return false;
            }
            if (!Objects.equals(this._metadataMatch, other.getMetadataMatch())) {
                return false;
            }
            if (!Objects.equals(this._metadataWrite, other.getMetadataWrite())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._tableFeatureProperties, other.getTableFeatureProperties())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableFeaturesImpl otherImpl = (TableFeaturesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TableFeatures [");
            boolean first = true;
            if (this._config != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_config=");
                builder.append(this._config);
            }
            if (this._maxEntries != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxEntries=");
                builder.append(this._maxEntries);
            }
            if (this._metadataMatch != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metadataMatch=");
                builder.append(this._metadataMatch);
            }
            if (this._metadataWrite != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metadataWrite=");
                builder.append(this._metadataWrite);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._tableFeatureProperties != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableFeatureProperties=");
                builder.append(this._tableFeatureProperties);
            }
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

