/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueuesBuilder
implements Builder<Queues> {
    private PortNumber _port;
    private QueueId _queueId;
    private List<QueueProperty> _queueProperty;
    Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = Collections.emptyMap();

    public QueuesBuilder() {
    }

    public QueuesBuilder(PacketQueue arg) {
        this._queueId = arg.getQueueId();
        this._port = arg.getPort();
        this._queueProperty = arg.getQueueProperty();
    }

    public QueuesBuilder(QueuePropertyHeader arg) {
        this._queueProperty = arg.getQueueProperty();
    }

    public QueuesBuilder(Queues base) {
        AugmentationHolder casted;
        this._port = base.getPort();
        this._queueId = base.getQueueId();
        this._queueProperty = base.getQueueProperty();
        if (base instanceof QueuesImpl) {
            QueuesImpl impl = (QueuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueuePropertyHeader) {
            this._queueProperty = ((QueuePropertyHeader)arg).getQueueProperty();
            isValidArg = true;
        }
        if (arg instanceof PacketQueue) {
            this._queueId = ((PacketQueue)arg).getQueueId();
            this._port = ((PacketQueue)arg).getPort();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketQueue] \nbut was: " + arg);
        }
    }

    public PortNumber getPort() {
        return this._port;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public List<QueueProperty> getQueueProperty() {
        return this._queueProperty;
    }

    public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueuesBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public QueuesBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public QueuesBuilder setQueueProperty(List<QueueProperty> value) {
        this._queueProperty = value;
        return this;
    }

    public QueuesBuilder addAugmentation(Class<? extends Augmentation<Queues>> augmentationType, Augmentation<Queues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueuesBuilder removeAugmentation(Class<? extends Augmentation<Queues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Queues build() {
        return new QueuesImpl(this);
    }

    private static final class QueuesImpl
    implements Queues {
        private final PortNumber _port;
        private final QueueId _queueId;
        private final List<QueueProperty> _queueProperty;
        private Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Queues> getImplementedInterface() {
            return Queues.class;
        }

        private QueuesImpl(QueuesBuilder base) {
            this._port = base.getPort();
            this._queueId = base.getQueueId();
            this._queueProperty = base.getQueueProperty();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(base.augmentation);
                }
            }
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public QueueId getQueueId() {
            return this._queueId;
        }

        @Override
        public List<QueueProperty> getQueueProperty() {
            return this._queueProperty;
        }

        public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._queueId);
            result = 31 * result + Objects.hashCode(this._queueProperty);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Queues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Queues other = (Queues)obj;
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (!Objects.equals(this._queueProperty, other.getQueueProperty())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QueuesImpl otherImpl = (QueuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Queues [");
            boolean first = true;
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (this._queueId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            if (this._queueProperty != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueProperty=");
                builder.append(this._queueProperty);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

