/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueuePropertyBuilder
implements Builder<QueueProperty> {
    private QueueProperties _property;
    Map<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> augmentation = Collections.emptyMap();

    public QueuePropertyBuilder() {
    }

    public QueuePropertyBuilder(QueueProperty base) {
        AugmentationHolder casted;
        this._property = base.getProperty();
        if (base instanceof QueuePropertyImpl) {
            QueuePropertyImpl impl = (QueuePropertyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>(casted.augmentations());
        }
    }

    public QueueProperties getProperty() {
        return this._property;
    }

    public <E extends Augmentation<QueueProperty>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueuePropertyBuilder setProperty(QueueProperties value) {
        this._property = value;
        return this;
    }

    public QueuePropertyBuilder addAugmentation(Class<? extends Augmentation<QueueProperty>> augmentationType, Augmentation<QueueProperty> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueuePropertyBuilder removeAugmentation(Class<? extends Augmentation<QueueProperty>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QueueProperty build() {
        return new QueuePropertyImpl(this);
    }

    private static final class QueuePropertyImpl
    implements QueueProperty {
        private final QueueProperties _property;
        private Map<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<QueueProperty> getImplementedInterface() {
            return QueueProperty.class;
        }

        private QueuePropertyImpl(QueuePropertyBuilder base) {
            this._property = base.getProperty();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>(base.augmentation);
                }
            }
        }

        @Override
        public QueueProperties getProperty() {
            return this._property;
        }

        public <E extends Augmentation<QueueProperty>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._property);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QueueProperty.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            QueueProperty other = (QueueProperty)obj;
            if (!Objects.equals((Object)this._property, (Object)other.getProperty())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QueuePropertyImpl otherImpl = (QueuePropertyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("QueueProperty [");
            boolean first = true;
            if (this._property != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_property=");
                builder.append((Object)this._property);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

