/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableFeaturePropertiesBuilder
implements Builder<TableFeatureProperties> {
    private TableFeaturesPropType _type;
    Map<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>> augmentation = Collections.emptyMap();

    public TableFeaturePropertiesBuilder() {
    }

    public TableFeaturePropertiesBuilder(TableFeatureProperties base) {
        AugmentationHolder casted;
        this._type = base.getType();
        if (base instanceof TableFeaturePropertiesImpl) {
            TableFeaturePropertiesImpl impl = (TableFeaturePropertiesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>>(casted.augmentations());
        }
    }

    public TableFeaturesPropType getType() {
        return this._type;
    }

    public <E extends Augmentation<TableFeatureProperties>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableFeaturePropertiesBuilder setType(TableFeaturesPropType value) {
        this._type = value;
        return this;
    }

    public TableFeaturePropertiesBuilder addAugmentation(Class<? extends Augmentation<TableFeatureProperties>> augmentationType, Augmentation<TableFeatureProperties> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableFeaturePropertiesBuilder removeAugmentation(Class<? extends Augmentation<TableFeatureProperties>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableFeatureProperties build() {
        return new TableFeaturePropertiesImpl(this);
    }

    private static final class TableFeaturePropertiesImpl
    implements TableFeatureProperties {
        private final TableFeaturesPropType _type;
        private Map<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableFeatureProperties> getImplementedInterface() {
            return TableFeatureProperties.class;
        }

        private TableFeaturePropertiesImpl(TableFeaturePropertiesBuilder base) {
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>>(base.augmentation);
                }
            }
        }

        @Override
        public TableFeaturesPropType getType() {
            return this._type;
        }

        public <E extends Augmentation<TableFeatureProperties>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableFeatureProperties.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableFeatureProperties other = (TableFeatureProperties)obj;
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableFeaturePropertiesImpl otherImpl = (TableFeaturePropertiesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableFeatureProperties>>, Augmentation<TableFeatureProperties>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TableFeatureProperties [");
            boolean first = true;
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

