/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.UdpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;

public class ChannelInitializerFactory {
    private long switchIdleTimeOut;
    private DeserializationFactory deserializationFactory;
    private SerializationFactory serializationFactory;
    private TlsConfiguration tlsConfig;
    private SwitchConnectionHandler switchConnectionHandler;
    private boolean useBarrier;

    public TcpChannelInitializer createPublishingChannelInitializer() {
        TcpChannelInitializer initializer = new TcpChannelInitializer();
        initializer.setSwitchIdleTimeout(this.switchIdleTimeOut);
        initializer.setDeserializationFactory(this.deserializationFactory);
        initializer.setSerializationFactory(this.serializationFactory);
        initializer.setTlsConfiguration(this.tlsConfig);
        initializer.setSwitchConnectionHandler(this.switchConnectionHandler);
        initializer.setUseBarrier(this.useBarrier);
        return initializer;
    }

    public UdpChannelInitializer createUdpChannelInitializer() {
        UdpChannelInitializer initializer = new UdpChannelInitializer();
        initializer.setSwitchIdleTimeout(this.switchIdleTimeOut);
        initializer.setDeserializationFactory(this.deserializationFactory);
        initializer.setSerializationFactory(this.serializationFactory);
        initializer.setSwitchConnectionHandler(this.switchConnectionHandler);
        return initializer;
    }

    public void setSwitchIdleTimeout(long switchIdleTimeOut) {
        this.switchIdleTimeOut = switchIdleTimeOut;
    }

    public void setDeserializationFactory(DeserializationFactory deserializationFactory) {
        this.deserializationFactory = deserializationFactory;
    }

    public void setSerializationFactory(SerializationFactory serializationFactory) {
        this.serializationFactory = serializationFactory;
    }

    public void setTlsConfig(TlsConfiguration tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public void setSwitchConnectionHandler(SwitchConnectionHandler switchConnectionHandler) {
        this.switchConnectionHandler = switchConnectionHandler;
    }

    public void setUseBarrier(boolean useBarrier) {
        this.useBarrier = useBarrier;
    }
}

