/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.opendaylight.openflowjava.protocol.impl.core.UdpConnectionMap;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageUdpWrapper;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDatagramPacketDecoder
extends SimpleChannelInboundHandler<VersionMessageUdpWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFDatagramPacketDecoder.class);
    private DeserializationFactory deserializationFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, VersionMessageUdpWrapper msg) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UdpVersionMessageWrapper received");
            LOGGER.debug("<< {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)msg.getMessageBuffer()));
        }
        try {
            DataObject dataObject = this.deserializationFactory.deserialize(msg.getMessageBuffer(), msg.getVersion());
            if (dataObject == null) {
                LOGGER.warn("Translated POJO is null");
            } else {
                MessageConsumer consumer = UdpConnectionMap.getMessageConsumer(msg.getAddress());
                consumer.consume(dataObject);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Message deserialization failed", (Throwable)e);
        }
        finally {
            msg.getMessageBuffer().release();
        }
    }

    public void setDeserializationFactory(DeserializationFactory deserializationFactory) {
        this.deserializationFactory = deserializationFactory;
    }
}

