/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.concurrent.Future;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.core.connection.UdpMessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDatagramPacketEncoder
extends MessageToMessageEncoder<UdpMessageListenerWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFDatagramPacketEncoder.class);
    private SerializationFactory serializationFactory;

    protected void encode(ChannelHandlerContext ctx, UdpMessageListenerWrapper wrapper, List<Object> out) throws Exception {
        LOGGER.trace("Encoding");
        try {
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
            this.serializationFactory.messageToBuffer(wrapper.getMsg().getVersion(), buffer, (DataObject)wrapper.getMsg());
            out.add(new DatagramPacket(buffer, wrapper.getAddress()));
        }
        catch (Exception e) {
            LOGGER.warn("Message serialization failed: {}", (Object)e.getMessage());
            ChannelFuture newFailedFuture = ctx.newFailedFuture((Throwable)e);
            wrapper.getListener().operationComplete((Future)newFailedFuture);
            return;
        }
    }

    public void setSerializationFactory(SerializationFactory serializationFactory) {
        this.serializationFactory = serializationFactory;
    }
}

