/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.core.UdpConnectionMap;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageUdpWrapper;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterFactory;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterFactoryImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDatagramPacketHandler
extends MessageToMessageDecoder<DatagramPacket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFDatagramPacketHandler.class);
    public static final byte LENGTH_OF_HEADER = 8;
    private static final byte LENGTH_INDEX_IN_HEADER = 2;
    private ConnectionAdapterFactory adapterFactory = new ConnectionAdapterFactoryImpl();
    private SwitchConnectionHandler connectionHandler;

    public OFDatagramPacketHandler(SwitchConnectionHandler sch) {
        this.connectionHandler = sch;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.warn("Unexpected exception from downstream.", cause);
        LOGGER.warn("Closing connection.");
        ctx.close();
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        ByteBuf bb;
        int readableBytes;
        LOGGER.debug("OFDatagramPacketFramer");
        MessageConsumer consumer = UdpConnectionMap.getMessageConsumer((InetSocketAddress)msg.sender());
        if (consumer == null) {
            ConnectionFacade connectionFacade = this.adapterFactory.createConnectionFacade(ctx.channel(), (InetSocketAddress)msg.sender(), false);
            this.connectionHandler.onSwitchConnected((ConnectionAdapter)connectionFacade);
            connectionFacade.checkListeners();
            UdpConnectionMap.addConnection((InetSocketAddress)msg.sender(), connectionFacade);
        }
        if ((readableBytes = (bb = (ByteBuf)msg.content()).readableBytes()) < 8) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping bytebuf - too few bytes for header: {} < {}", (Object)readableBytes, (Object)8);
                LOGGER.debug("bb: {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)bb));
            }
            return;
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        LOGGER.debug("length of actual message: {}", (Object)length);
        if (readableBytes < length) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping bytebuf - too few bytes for msg: {} < {}", (Object)readableBytes, (Object)length);
                LOGGER.debug("bytebuffer: {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)bb));
            }
            return;
        }
        LOGGER.debug("OF Protocol message received, type:{}", (Object)bb.getByte(bb.readerIndex() + 1));
        byte version = bb.readByte();
        if (version == 4 || version == 1) {
            LOGGER.debug("detected version: {}", (Object)version);
            ByteBuf messageBuffer = bb.slice();
            out.add(new VersionMessageUdpWrapper(version, messageBuffer, (InetSocketAddress)msg.sender()));
            messageBuffer.retain();
        } else {
            LOGGER.warn("detected version: {} - currently not supported", (Object)version);
        }
        bb.skipBytes(bb.readableBytes());
    }
}

