/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDecoder
extends MessageToMessageDecoder<VersionMessageWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFDecoder.class);
    private final StatisticsCounters statisticsCounter;
    private DeserializationFactory deserializationFactory;

    public OFDecoder() {
        LOGGER.trace("Creating OF 1.3 Decoder");
        this.statisticsCounter = StatisticsCounters.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, VersionMessageWrapper msg, List<Object> out) throws Exception {
        this.statisticsCounter.incrementCounter(CounterEventTypes.US_RECEIVED_IN_OFJAVA);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("VersionMessageWrapper received");
            LOGGER.debug("<< {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)msg.getMessageBuffer()));
        }
        try {
            DataObject dataObject = this.deserializationFactory.deserialize(msg.getMessageBuffer(), msg.getVersion());
            if (dataObject == null) {
                LOGGER.warn("Translated POJO is null");
                this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_FAIL);
            } else {
                out.add(dataObject);
                this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_SUCCESS);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Message deserialization failed", (Throwable)e);
            this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_FAIL);
        }
        finally {
            msg.getMessageBuffer().release();
        }
    }

    public void setDeserializationFactory(DeserializationFactory deserializationFactory) {
        this.deserializationFactory = deserializationFactory;
    }
}

