/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.concurrent.Future;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFEncoder
extends MessageToByteEncoder<MessageListenerWrapper> {
    private static final Logger LOG = LoggerFactory.getLogger(OFEncoder.class);
    private SerializationFactory serializationFactory;
    private final StatisticsCounters statisticsCounters = StatisticsCounters.getInstance();

    public OFEncoder() {
        LOG.trace("Creating OF13Encoder");
    }

    protected void encode(ChannelHandlerContext ctx, MessageListenerWrapper wrapper, ByteBuf out) throws Exception {
        LOG.trace("Encoding");
        try {
            this.serializationFactory.messageToBuffer(wrapper.getMsg().getVersion(), out, (DataObject)wrapper.getMsg());
            if (wrapper.getMsg() instanceof FlowModInput) {
                this.statisticsCounters.incrementCounter(CounterEventTypes.DS_FLOW_MODS_SENT);
            }
            this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENCODE_SUCCESS);
        }
        catch (Exception e) {
            LOG.warn("Message serialization failed ", (Throwable)e);
            this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENCODE_FAIL);
            if (wrapper.getListener() != null) {
                ChannelFuture newFailedFuture = ctx.newFailedFuture((Throwable)e);
                wrapper.getListener().operationComplete((Future)newFailedFuture);
            }
            out.clear();
            return;
        }
    }

    public void setSerializationFactory(SerializationFactory serializationFactory) {
        this.serializationFactory = serializationFactory;
    }
}

