/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.NotSslRecordException;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFFrameDecoder
extends ByteToMessageDecoder {
    public static final byte LENGTH_OF_HEADER = 8;
    private static final byte LENGTH_INDEX_IN_HEADER = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(OFFrameDecoder.class);
    private ConnectionFacade connectionFacade;
    private boolean firstTlsPass = false;

    public OFFrameDecoder(ConnectionFacade connectionFacade, boolean tlsPresent) {
        LOGGER.trace("Creating OFFrameDecoder");
        if (tlsPresent) {
            this.firstTlsPass = true;
        }
        this.connectionFacade = connectionFacade;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof NotSslRecordException) {
            LOGGER.warn("Not an TLS record exception - please verify TLS configuration.");
        } else {
            LOGGER.warn("Unexpected exception from downstream.", cause);
        }
        LOGGER.warn("Closing connection.");
        ctx.close();
    }

    protected void decode(ChannelHandlerContext chc, ByteBuf bb, List<Object> list) throws Exception {
        int readableBytes;
        if (this.firstTlsPass) {
            this.connectionFacade.fireConnectionReadyNotification();
            this.firstTlsPass = false;
        }
        if ((readableBytes = bb.readableBytes()) < 8) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping bytebuf - too few bytes for header: {} < {}", (Object)readableBytes, (Object)8);
                LOGGER.debug("bb: {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)bb));
            }
            return;
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        LOGGER.debug("length of actual message: {}", (Object)length);
        if (readableBytes < length) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping bytebuf - too few bytes for msg: {} < {}", (Object)readableBytes, (Object)length);
                LOGGER.debug("bytebuffer: {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)bb));
            }
            return;
        }
        LOGGER.debug("OF Protocol message received, type:{}", (Object)bb.getByte(bb.readerIndex() + 1));
        ByteBuf messageBuffer = bb.slice(bb.readerIndex(), length);
        list.add(messageBuffer);
        messageBuffer.retain();
        bb.skipBytes(length);
    }
}

