/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFVersionDetector
extends ByteToMessageDecoder {
    private static final byte OF10_VERSION_ID = 1;
    private static final byte OF13_VERSION_ID = 4;
    private static final short OF_PACKETIN = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(OFVersionDetector.class);
    private final StatisticsCounters statisticsCounters;
    private volatile boolean filterPacketIns;

    public OFVersionDetector() {
        LOGGER.trace("Creating OFVersionDetector");
        this.statisticsCounters = StatisticsCounters.getInstance();
    }

    public void setFilterPacketIns(boolean enabled) {
        this.filterPacketIns = enabled;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!in.isReadable()) {
            LOGGER.debug("not enough data");
            in.release();
            return;
        }
        byte version = in.readByte();
        if (version == 4 || version == 1) {
            LOGGER.debug("detected version: {}", (Object)version);
            if (!this.filterPacketIns || 10 != in.getUnsignedByte(in.readerIndex())) {
                ByteBuf messageBuffer = in.slice();
                out.add(new VersionMessageWrapper(version, messageBuffer));
                messageBuffer.retain();
            } else {
                LOGGER.debug("dropped packetin");
                this.statisticsCounters.incrementCounter(CounterEventTypes.US_DROPPED_PACKET_IN);
            }
        } else {
            LOGGER.warn("detected version: {} - currently not supported", (Object)version);
        }
        in.skipBytes(in.readableBytes());
    }
}

