/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.nio.NioEventLoopGroup;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.ActionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterActionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterInstructionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.core.ChannelInitializerFactory;
import org.opendaylight.openflowjava.protocol.impl.core.ConnectionInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.TcpConnectionInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.TcpHandler;
import org.opendaylight.openflowjava.protocol.impl.core.UdpHandler;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchConnectionProviderImpl
implements SwitchConnectionProvider,
ConnectionInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchConnectionProviderImpl.class);
    private SwitchConnectionHandler switchConnectionHandler;
    private ServerFacade serverFacade;
    private ConnectionConfiguration connConfig;
    private final SerializationFactory serializationFactory;
    private final SerializerRegistry serializerRegistry = new SerializerRegistryImpl();
    private final DeserializerRegistry deserializerRegistry;
    private final DeserializationFactory deserializationFactory;
    private TcpConnectionInitializer connectionInitializer;

    public SwitchConnectionProviderImpl() {
        this.serializerRegistry.init();
        this.serializationFactory = new SerializationFactory();
        this.serializationFactory.setSerializerTable(this.serializerRegistry);
        this.deserializerRegistry = new DeserializerRegistryImpl();
        this.deserializerRegistry.init();
        this.deserializationFactory = new DeserializationFactory();
        this.deserializationFactory.setRegistry(this.deserializerRegistry);
    }

    public void setConfiguration(ConnectionConfiguration connConfig) {
        this.connConfig = connConfig;
    }

    public void setSwitchConnectionHandler(SwitchConnectionHandler switchConnectionHandler) {
        LOGGER.debug("setSwitchConnectionHandler");
        this.switchConnectionHandler = switchConnectionHandler;
    }

    public ListenableFuture<Boolean> shutdown() {
        LOGGER.debug("Shutdown summoned");
        if (this.serverFacade == null) {
            LOGGER.warn("Can not shutdown - not configured or started");
            throw new IllegalStateException("SwitchConnectionProvider is not started or not configured.");
        }
        return this.serverFacade.shutdown();
    }

    public ListenableFuture<Boolean> startup() {
        LOGGER.debug("Startup summoned");
        ListenableFuture<Boolean> result = null;
        try {
            this.serverFacade = this.createAndConfigureServer();
            if (this.switchConnectionHandler == null) {
                throw new IllegalStateException("SwitchConnectionHandler is not set");
            }
            new Thread(this.serverFacade).start();
            result = this.serverFacade.getIsOnlineFuture();
        }
        catch (Exception e) {
            ListenableFuture<Boolean> exResult = SettableFuture.create();
            exResult.setException((Throwable)e);
            result = exResult;
        }
        return result;
    }

    private ServerFacade createAndConfigureServer() {
        LOGGER.debug("Configuring ..");
        ServerFacade server = null;
        ChannelInitializerFactory factory = new ChannelInitializerFactory();
        factory.setSwitchConnectionHandler(this.switchConnectionHandler);
        factory.setSwitchIdleTimeout(this.connConfig.getSwitchIdleTimeout());
        factory.setTlsConfig(this.connConfig.getTlsConfiguration());
        factory.setSerializationFactory(this.serializationFactory);
        factory.setDeserializationFactory(this.deserializationFactory);
        factory.setUseBarrier(this.connConfig.useBarrier());
        TransportProtocol transportProtocol = (TransportProtocol)this.connConfig.getTransferProtocol();
        if (transportProtocol.equals((Object)TransportProtocol.TCP) || transportProtocol.equals((Object)TransportProtocol.TLS)) {
            server = new TcpHandler(this.connConfig.getAddress(), this.connConfig.getPort());
            TcpChannelInitializer channelInitializer = factory.createPublishingChannelInitializer();
            ((TcpHandler)server).setChannelInitializer(channelInitializer);
            ((TcpHandler)server).initiateEventLoopGroups(this.connConfig.getThreadConfiguration());
            NioEventLoopGroup workerGroupFromTcpHandler = ((TcpHandler)server).getWorkerGroup();
            this.connectionInitializer = new TcpConnectionInitializer(workerGroupFromTcpHandler);
            this.connectionInitializer.setChannelInitializer(channelInitializer);
            this.connectionInitializer.run();
        } else if (transportProtocol.equals((Object)TransportProtocol.UDP)) {
            server = new UdpHandler(this.connConfig.getAddress(), this.connConfig.getPort());
            ((UdpHandler)server).setChannelInitializer(factory.createUdpChannelInitializer());
        } else {
            throw new IllegalStateException("Unknown transport protocol received: " + transportProtocol);
        }
        server.setThreadConfig(this.connConfig.getThreadConfiguration());
        return server;
    }

    public ServerFacade getServerFacade() {
        return this.serverFacade;
    }

    public void close() throws Exception {
        this.shutdown();
    }

    public boolean unregisterSerializer(ExperimenterSerializerKey key) {
        return this.serializerRegistry.unregisterSerializer((MessageTypeKey)key);
    }

    public boolean unregisterDeserializer(ExperimenterDeserializerKey key) {
        return this.deserializerRegistry.unregisterDeserializer((MessageCodeKey)key);
    }

    public void registerActionSerializer(ActionSerializerKey<?> key, OFGeneralSerializer serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerActionDeserializer(ExperimenterActionDeserializerKey key, OFGeneralDeserializer deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerInstructionSerializer(InstructionSerializerKey<?> key, OFGeneralSerializer serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerInstructionDeserializer(ExperimenterInstructionDeserializerKey key, OFGeneralDeserializer deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public <C extends OxmClassBase, F extends MatchField> void registerMatchEntrySerializer(MatchEntrySerializerKey<C, F> key, OFGeneralSerializer serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerMatchEntryDeserializer(MatchEntryDeserializerKey key, OFGeneralDeserializer deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerErrorDeserializer(ExperimenterIdDeserializerKey key, OFDeserializer<ErrorMessage> deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerExperimenterMessageDeserializer(ExperimenterIdDeserializerKey key, OFDeserializer<? extends ExperimenterDataOfChoice> deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerMultipartReplyMessageDeserializer(ExperimenterIdDeserializerKey key, OFDeserializer<? extends ExperimenterDataOfChoice> deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerMultipartReplyTFDeserializer(ExperimenterIdDeserializerKey key, OFGeneralDeserializer deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerQueuePropertyDeserializer(ExperimenterIdDeserializerKey key, OFDeserializer<QueueProperty> deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerMeterBandDeserializer(ExperimenterIdDeserializerKey key, OFDeserializer<MeterBandExperimenterCase> deserializer) {
        this.deserializerRegistry.registerDeserializer((MessageCodeKey)key, deserializer);
    }

    public void registerExperimenterMessageSerializer(ExperimenterIdSerializerKey<? extends ExperimenterDataOfChoice> key, OFSerializer<? extends ExperimenterDataOfChoice> serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerMultipartRequestSerializer(ExperimenterIdSerializerKey<? extends ExperimenterDataOfChoice> key, OFSerializer<? extends ExperimenterDataOfChoice> serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerMultipartRequestTFSerializer(ExperimenterIdSerializerKey<TableFeatureProperties> key, OFGeneralSerializer serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    public void registerMeterBandSerializer(ExperimenterIdSerializerKey<MeterBandExperimenterCase> key, OFSerializer<MeterBandExperimenterCase> serializer) {
        this.serializerRegistry.registerSerializer(key, serializer);
    }

    @Override
    public void initiateConnection(String host, int port) {
        this.connectionInitializer.initiateConnection(host, port);
    }

    public ConnectionConfiguration getConfiguration() {
        return this.connConfig;
    }
}

