/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.impl.core.DelegatingInboundHandler;
import org.opendaylight.openflowjava.protocol.impl.core.IdleHandler;
import org.opendaylight.openflowjava.protocol.impl.core.OFDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFFrameDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFVersionDetector;
import org.opendaylight.openflowjava.protocol.impl.core.PipelineHandlers;
import org.opendaylight.openflowjava.protocol.impl.core.ProtocolChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.SslContextFactory;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterFactory;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterFactoryImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpChannelInitializer
extends ProtocolChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpChannelInitializer.class);
    private final DefaultChannelGroup allChannels;
    private final ConnectionAdapterFactory connectionAdapterFactory;

    public TcpChannelInitializer() {
        this(new DefaultChannelGroup("netty-receiver", null), new ConnectionAdapterFactoryImpl());
    }

    protected TcpChannelInitializer(DefaultChannelGroup channelGroup, ConnectionAdapterFactory connAdaptorFactory) {
        this.allChannels = channelGroup;
        this.connectionAdapterFactory = connAdaptorFactory;
    }

    protected void initChannel(SocketChannel ch) {
        if (ch.remoteAddress() != null) {
            InetAddress switchAddress = ch.remoteAddress().getAddress();
            int port = ch.localAddress().getPort();
            int remotePort = ch.remoteAddress().getPort();
            LOGGER.debug("Incoming connection from (remote address): {}:{} --> :{}", new Object[]{switchAddress.toString(), remotePort, port});
            if (!this.getSwitchConnectionHandler().accept(switchAddress)) {
                ch.disconnect();
                LOGGER.debug("Incoming connection rejected");
                return;
            }
        }
        LOGGER.debug("Incoming connection accepted - building pipeline");
        this.allChannels.add((Channel)ch);
        ConnectionFacade connectionFacade = null;
        connectionFacade = this.connectionAdapterFactory.createConnectionFacade((Channel)ch, null, this.useBarrier());
        try {
            LOGGER.debug("calling plugin: {}", (Object)this.getSwitchConnectionHandler());
            this.getSwitchConnectionHandler().onSwitchConnected((ConnectionAdapter)connectionFacade);
            connectionFacade.checkListeners();
            ch.pipeline().addLast(PipelineHandlers.IDLE_HANDLER.name(), (ChannelHandler)new IdleHandler(this.getSwitchIdleTimeout(), TimeUnit.MILLISECONDS));
            boolean tlsPresent = false;
            if (this.getTlsConfiguration() != null) {
                tlsPresent = true;
                SslContextFactory sslFactory = new SslContextFactory(this.getTlsConfiguration());
                SSLEngine engine = sslFactory.getServerContext().createSSLEngine();
                engine.setNeedClientAuth(true);
                engine.setUseClientMode(false);
                SslHandler ssl = new SslHandler(engine);
                Future handshakeFuture = ssl.handshakeFuture();
                final ConnectionFacade finalConnectionFacade = connectionFacade;
                handshakeFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                    public void operationComplete(Future<? super Channel> future) throws Exception {
                        finalConnectionFacade.fireConnectionReadyNotification();
                    }
                });
                ch.pipeline().addLast(PipelineHandlers.SSL_HANDLER.name(), (ChannelHandler)ssl);
            }
            ch.pipeline().addLast(PipelineHandlers.OF_FRAME_DECODER.name(), (ChannelHandler)new OFFrameDecoder(connectionFacade, tlsPresent));
            ch.pipeline().addLast(PipelineHandlers.OF_VERSION_DETECTOR.name(), (ChannelHandler)new OFVersionDetector());
            OFDecoder ofDecoder = new OFDecoder();
            ofDecoder.setDeserializationFactory(this.getDeserializationFactory());
            ch.pipeline().addLast(PipelineHandlers.OF_DECODER.name(), (ChannelHandler)ofDecoder);
            OFEncoder ofEncoder = new OFEncoder();
            ofEncoder.setSerializationFactory(this.getSerializationFactory());
            ch.pipeline().addLast(PipelineHandlers.OF_ENCODER.name(), (ChannelHandler)ofEncoder);
            ch.pipeline().addLast(PipelineHandlers.DELEGATING_INBOUND_HANDLER.name(), (ChannelHandler)new DelegatingInboundHandler(connectionFacade));
            if (!tlsPresent) {
                connectionFacade.fireConnectionReadyNotification();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize channel", (Throwable)e);
            ch.close();
        }
    }

    public Iterator<Channel> getConnectionIterator() {
        return this.allChannels.iterator();
    }

    public int size() {
        return this.allChannels.size();
    }
}

