/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.opendaylight.openflowjava.protocol.api.connection.ThreadConfiguration;
import org.opendaylight.openflowjava.protocol.impl.core.ConnectionInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnectionInitializer
implements ServerFacade,
ConnectionInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpConnectionInitializer.class);
    private EventLoopGroup workerGroup;
    private ThreadConfiguration threadConfig;
    private TcpChannelInitializer channelInitializer;
    private Bootstrap b;

    public TcpConnectionInitializer(NioEventLoopGroup workerGroup) {
        Preconditions.checkNotNull((Object)workerGroup, (Object)"WorkerGroup can't be null");
        this.workerGroup = workerGroup;
    }

    @Override
    public void run() {
        this.b = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.b.group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.channelInitializer);
    }

    @Override
    public ListenableFuture<Boolean> shutdown() {
        SettableFuture result = SettableFuture.create();
        this.workerGroup.shutdownGracefully();
        return result;
    }

    @Override
    public ListenableFuture<Boolean> getIsOnlineFuture() {
        return null;
    }

    @Override
    public void setThreadConfig(ThreadConfiguration threadConfig) {
        this.threadConfig = threadConfig;
    }

    @Override
    public void initiateConnection(String host, int port) {
        try {
            this.b.connect(host, port).sync();
        }
        catch (InterruptedException e) {
            LOGGER.error("Unable to initiate connection", (Throwable)e);
        }
    }

    public void setChannelInitializer(TcpChannelInitializer channelInitializer) {
        this.channelInitializer = channelInitializer;
    }
}

