/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opendaylight.openflowjava.protocol.api.connection.ThreadConfiguration;
import org.opendaylight.openflowjava.protocol.impl.core.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpHandler
implements ServerFacade {
    private static final int DEFAULT_WRITE_HIGH_WATERMARK = 64;
    private static final int DEFAULT_WRITE_LOW_WATERMARK = 32;
    private static final int DEFAULT_WRITE_SPIN_COUNT = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpHandler.class);
    private int port;
    private String address;
    private final InetAddress startupAddress;
    private NioEventLoopGroup workerGroup;
    private NioEventLoopGroup bossGroup;
    private final SettableFuture<Boolean> isOnlineFuture;
    private ThreadConfiguration threadConfig;
    private TcpChannelInitializer channelInitializer;

    public TcpHandler(int port) {
        this(null, port);
    }

    public TcpHandler(InetAddress address, int port) {
        this.port = port;
        this.startupAddress = address;
        this.isOnlineFuture = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChannelFuture f;
        this.workerGroup.setIoRatio(100);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)this.channelInitializer).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)65536).childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)32768).childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)16);
            f = this.startupAddress != null ? b.bind(this.startupAddress.getHostAddress(), this.port).sync() : b.bind(this.port).sync();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while binding port {}", (Object)this.port, (Object)e);
            return;
        }
        try {
            InetSocketAddress isa = (InetSocketAddress)f.channel().localAddress();
            this.address = isa.getHostString();
            this.port = isa.getPort();
            LOGGER.debug("address from tcphandler: {}", (Object)this.address);
            this.isOnlineFuture.set((Object)true);
            LOGGER.info("Switch listener started and ready to accept incoming tcp/tls connections on port: {}", (Object)this.port);
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for port {} shutdown", (Object)this.port, (Object)e);
        }
        finally {
            this.shutdown();
        }
    }

    @Override
    public ListenableFuture<Boolean> shutdown() {
        final SettableFuture result = SettableFuture.create();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

            public void operationComplete(Future<Object> downResult) throws Exception {
                result.set((Object)downResult.isSuccess());
                if (downResult.cause() != null) {
                    result.setException(downResult.cause());
                }
            }
        });
        return result;
    }

    public int getNumberOfConnections() {
        return this.channelInitializer.size();
    }

    @Override
    public ListenableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setChannelInitializer(TcpChannelInitializer channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    @Override
    public void setThreadConfig(ThreadConfiguration threadConfig) {
        this.threadConfig = threadConfig;
    }

    public void initiateEventLoopGroups(ThreadConfiguration threadConfiguration) {
        if (threadConfiguration != null) {
            this.bossGroup = new NioEventLoopGroup(threadConfiguration.getBossThreadCount());
            this.workerGroup = new NioEventLoopGroup(threadConfiguration.getWorkerThreadCount());
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
        }
    }

    public NioEventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }
}

