/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;

public final class UdpConnectionMap {
    private static Map<InetSocketAddress, MessageConsumer> connectionMap = new ConcurrentHashMap<InetSocketAddress, MessageConsumer>();

    private UdpConnectionMap() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static MessageConsumer getMessageConsumer(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Address can not be null");
        }
        return connectionMap.get(address);
    }

    public static void addConnection(InetSocketAddress address, MessageConsumer consumer) {
        if (address == null) {
            throw new IllegalArgumentException("Address can not be null");
        }
        connectionMap.put(address, consumer);
    }

    public static void removeConnection(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Address can not be null");
        }
        connectionMap.remove(address);
    }
}

