/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opendaylight.openflowjava.protocol.api.connection.ThreadConfiguration;
import org.opendaylight.openflowjava.protocol.impl.core.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.UdpChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpHandler
implements ServerFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpHandler.class);
    private int port;
    private EventLoopGroup group;
    private final InetAddress startupAddress;
    private final SettableFuture<Boolean> isOnlineFuture;
    private UdpChannelInitializer channelInitializer;
    private ThreadConfiguration threadConfig;

    public UdpHandler(int port) {
        this(null, port);
    }

    public UdpHandler(InetAddress address, int port) {
        this.port = port;
        this.startupAddress = address;
        this.isOnlineFuture = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChannelFuture f;
        this.group = this.threadConfig != null ? new NioEventLoopGroup(this.threadConfig.getWorkerThreadCount()) : new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)false)).handler((ChannelHandler)this.channelInitializer);
            f = this.startupAddress != null ? b.bind(this.startupAddress.getHostAddress(), this.port).sync() : b.bind(this.port).sync();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while binding port {}", (Object)this.port, (Object)e);
            return;
        }
        try {
            InetSocketAddress isa = (InetSocketAddress)f.channel().localAddress();
            String address = isa.getHostString();
            this.port = isa.getPort();
            LOGGER.debug("Address from udpHandler: {}", (Object)address);
            this.isOnlineFuture.set((Object)true);
            LOGGER.info("Switch listener started and ready to accept incoming udp connections on port: {}", (Object)this.port);
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for port {} shutdown", (Object)this.port, (Object)e);
        }
        finally {
            this.shutdown();
        }
    }

    @Override
    public ListenableFuture<Boolean> shutdown() {
        final SettableFuture result = SettableFuture.create();
        this.group.shutdownGracefully().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

            public void operationComplete(Future<Object> downResult) throws Exception {
                result.set((Object)downResult.isSuccess());
                if (downResult.cause() != null) {
                    result.setException(downResult.cause());
                }
            }
        });
        return result;
    }

    @Override
    public ListenableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    public int getPort() {
        return this.port;
    }

    public void setChannelInitializer(UdpChannelInitializer channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    @Override
    public void setThreadConfig(ThreadConfiguration threadConfig) {
        this.threadConfig = threadConfig;
    }
}

