/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ChannelOutboundQueue;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.openflowjava.protocol.impl.core.connection.SimpleRpcListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConnectionAdapter
implements ConnectionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConnectionAdapter.class);
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private static final Exception QUEUE_FULL_EXCEPTION = new RejectedExecutionException("Output queue is full");
    private static final int DEFAULT_QUEUE_DEPTH = 1024;
    protected static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            if (!notification.getCause().equals((Object)RemovalCause.EXPLICIT)) {
                ((ResponseExpectedRpcListener)notification.getValue()).discard();
            }
        }
    };
    protected final Channel channel;
    protected final InetSocketAddress address;
    protected boolean disconnectOccured = false;
    protected final ChannelOutboundQueue output;
    protected Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> responseCache;

    AbstractConnectionAdapter(@Nonnull Channel channel, @Nullable InetSocketAddress address) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel);
        this.address = address;
        this.responseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.output = new ChannelOutboundQueue(channel, 1024, address);
        channel.pipeline().addLast(new ChannelHandler[]{this.output});
    }

    public java.util.concurrent.Future<Boolean> disconnect() {
        ChannelFuture disconnectResult = this.channel.disconnect();
        this.responseCache.invalidateAll();
        this.disconnectOccured = true;
        return AbstractConnectionAdapter.handleTransportChannelFuture(disconnectResult);
    }

    public java.util.concurrent.Future<RpcResult<BarrierOutput>> barrier(BarrierInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, BarrierOutput.class, "barrier-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<EchoOutput>> echo(EchoInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, EchoOutput.class, "echo-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> echoReply(EchoReplyInput input) {
        return this.sendToSwitchFuture((DataObject)input, "echo-reply sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> experimenter(ExperimenterInput input) {
        return this.sendToSwitchFuture((DataObject)input, "experimenter sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> flowMod(FlowModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "flow-mod sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetConfigOutput>> getConfig(GetConfigInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetConfigOutput.class, "get-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetFeaturesOutput>> getFeatures(GetFeaturesInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetFeaturesOutput.class, "get-features-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetQueueConfigOutput>> getQueueConfig(GetQueueConfigInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetQueueConfigOutput.class, "get-queue-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> groupMod(GroupModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "group-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> hello(HelloInput input) {
        return this.sendToSwitchFuture((DataObject)input, "hello-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> meterMod(MeterModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "meter-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> packetOut(PacketOutInput input) {
        return this.sendToSwitchFuture((DataObject)input, "packet-out-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> multipartRequest(MultipartRequestInput input) {
        return this.sendToSwitchFuture((DataObject)input, "multi-part-request sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> portMod(PortModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "port-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<RoleRequestOutput>> roleRequest(RoleRequestInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, RoleRequestOutput.class, "role-request-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> setConfig(SetConfigInput input) {
        return this.sendToSwitchFuture((DataObject)input, "set-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> tableMod(TableModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "table-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetAsyncOutput>> getAsync(GetAsyncInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetAsyncOutput.class, "get-async-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> setAsync(SetAsyncInput input) {
        return this.sendToSwitchFuture((DataObject)input, "set-async-input sending failed");
    }

    public boolean isAlive() {
        return this.channel.isOpen();
    }

    public boolean isAutoRead() {
        return this.channel.config().isAutoRead();
    }

    public void setAutoRead(boolean autoRead) {
        this.channel.config().setAutoRead(autoRead);
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @VisibleForTesting
    void setResponseCache(Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache) {
        this.responseCache = cache;
    }

    protected ResponseExpectedRpcListener<?> findRpcResponse(RpcResponseKey key) {
        return (ResponseExpectedRpcListener)this.responseCache.getIfPresent((Object)key);
    }

    protected <IN extends OfHeader, OUT extends OfHeader> ListenableFuture<RpcResult<OUT>> sendToSwitchExpectRpcResultFuture(IN input, Class<OUT> responseClazz, String failureInfo) {
        RpcResponseKey key = new RpcResponseKey(input.getXid(), responseClazz.getName());
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener(input, failureInfo, this.responseCache, key);
        return this.enqueueMessage(listener);
    }

    protected ListenableFuture<RpcResult<Void>> sendToSwitchFuture(DataObject input, String failureInfo) {
        return this.enqueueMessage(new SimpleRpcListener(input, failureInfo));
    }

    private <T> ListenableFuture<RpcResult<T>> enqueueMessage(AbstractRpcListener<T> promise) {
        LOG.debug("Submitting promise {}", promise);
        if (!this.output.enqueue(promise)) {
            LOG.debug("Message queue is full, rejecting execution");
            promise.failedRpc(QUEUE_FULL_EXCEPTION);
        } else {
            LOG.debug("Promise enqueued successfully");
        }
        return promise.getResult();
    }

    private static SettableFuture<Boolean> handleTransportChannelFuture(ChannelFuture resultFuture) {
        final SettableFuture transportResult = SettableFuture.create();
        resultFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                transportResult.set((Object)future.isSuccess());
                if (!future.isSuccess()) {
                    transportResult.setException(future.cause());
                }
            }
        });
        return transportResult;
    }
}

