/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.ListenableFuture;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractConnectionAdapter;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;

abstract class AbstractConnectionAdapterStatistics
extends AbstractConnectionAdapter
implements MessageConsumer {
    private final StatisticsCounters statisticsCounters = StatisticsCounters.getInstance();

    AbstractConnectionAdapterStatistics(Channel channel, InetSocketAddress address) {
        super(channel, address);
    }

    @Override
    public Future<RpcResult<Void>> flowMod(FlowModInput input) {
        this.statisticsCounters.incrementCounter(CounterEventTypes.DS_FLOW_MODS_ENTERED);
        return super.flowMod(input);
    }

    @Override
    protected <IN extends OfHeader, OUT extends OfHeader> ListenableFuture<RpcResult<OUT>> sendToSwitchExpectRpcResultFuture(IN input, Class<OUT> responseClazz, String failureInfo) {
        this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENTERED_OFJAVA);
        return super.sendToSwitchExpectRpcResultFuture(input, responseClazz, failureInfo);
    }

    @Override
    protected ListenableFuture<RpcResult<Void>> sendToSwitchFuture(DataObject input, String failureInfo) {
        this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENTERED_OFJAVA);
        return super.sendToSwitchFuture(input, failureInfo);
    }

    @Override
    public void consume(DataObject message) {
        if (Notification.class.isInstance(message)) {
            if (!DisconnectEvent.class.isInstance(message) && !SwitchIdleEvent.class.isInstance(message)) {
                this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
            }
        } else if (OfHeader.class.isInstance(message)) {
            this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
        }
        this.consumeDeviceMessage(message);
    }

    protected abstract void consumeDeviceMessage(DataObject var1);
}

