/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueue;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractOutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.openflowjava.protocol.impl.core.connection.StackedSegment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStackedOutboundQueue
implements OutboundQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStackedOutboundQueue.class);
    protected static final AtomicLongFieldUpdater<AbstractStackedOutboundQueue> LAST_XID_OFFSET_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractStackedOutboundQueue.class, "lastXid");
    @GuardedBy(value="unflushedSegments")
    protected volatile StackedSegment firstSegment;
    @GuardedBy(value="unflushedSegments")
    protected final List<StackedSegment> unflushedSegments = new ArrayList<StackedSegment>(2);
    @GuardedBy(value="unflushedSegments")
    protected final List<StackedSegment> uncompletedSegments = new ArrayList<StackedSegment>(2);
    private volatile long lastXid = -1L;
    private volatile long allocatedXid = -1L;
    @GuardedBy(value="unflushedSegments")
    protected Integer shutdownOffset;
    protected int flushOffset;
    protected final AbstractOutboundQueueManager<?, ?> manager;

    AbstractStackedOutboundQueue(AbstractOutboundQueueManager<?, ?> manager) {
        this.manager = (AbstractOutboundQueueManager)Preconditions.checkNotNull(manager);
        this.firstSegment = StackedSegment.create(0L);
        this.uncompletedSegments.add(this.firstSegment);
        this.unflushedSegments.add(this.firstSegment);
    }

    @GuardedBy(value="unflushedSegments")
    protected void ensureSegment(StackedSegment first, int offset) {
        int segmentOffset = offset / 4096;
        LOG.debug("Queue {} slow offset {} maps to {} segments {}", new Object[]{this, offset, segmentOffset, this.unflushedSegments.size()});
        for (int i = this.unflushedSegments.size(); i <= segmentOffset; ++i) {
            StackedSegment newSegment = StackedSegment.create(first.getBaseXid() + (long)(4096 * i));
            LOG.debug("Adding segment {}", (Object)newSegment);
            this.unflushedSegments.add(newSegment);
        }
        this.allocatedXid = this.unflushedSegments.get(this.unflushedSegments.size() - 1).getEndXid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long reserveEntry() {
        StackedSegment fastSegment;
        long xid = LAST_XID_OFFSET_UPDATER.incrementAndGet(this);
        if (xid >= (fastSegment = this.firstSegment).getBaseXid() + 4096L) {
            if (xid >= this.allocatedXid) {
                LOG.debug("Queue {} falling back to slow reservation for XID {}", (Object)this, (Object)xid);
                List<StackedSegment> list = this.unflushedSegments;
                synchronized (list) {
                    LOG.debug("Queue {} executing slow reservation for XID {}", (Object)this, (Object)xid);
                    if (this.shutdownOffset != null) {
                        LOG.debug("Queue {} is being shutdown, failing reservation", (Object)this);
                        return null;
                    }
                    StackedSegment slowSegment = this.firstSegment;
                    int slowOffset = (int)(xid - slowSegment.getBaseXid());
                    Verify.verify((slowOffset >= 0 ? 1 : 0) != 0);
                    this.ensureSegment(slowSegment, slowOffset);
                    LOG.debug("Queue {} slow reservation finished", (Object)this);
                }
            } else {
                LOG.debug("Queue {} XID {} is already backed", (Object)this, (Object)xid);
            }
        }
        LOG.trace("Queue {} allocated XID {}", (Object)this, (Object)xid);
        return xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeEntries(@Nonnull Channel channel, long now) {
        StackedSegment segment = this.firstSegment;
        int entries = 0;
        while (channel.isWritable()) {
            OutboundQueueEntry entry = segment.getEntry(this.flushOffset);
            if (!entry.isCommitted()) {
                LOG.debug("Queue {} XID {} segment {} offset {} not committed yet", new Object[]{this, segment.getBaseXid() + (long)this.flushOffset, segment, this.flushOffset});
                break;
            }
            LOG.trace("Queue {} flushing entry at offset {}", (Object)this, (Object)this.flushOffset);
            OfHeader message = entry.takeMessage();
            ++this.flushOffset;
            ++entries;
            if (message != null) {
                this.manager.writeMessage(message, now);
            } else {
                entry.complete(null);
            }
            if (this.flushOffset < 4096) continue;
            List<StackedSegment> list = this.unflushedSegments;
            synchronized (list) {
                LOG.debug("Flush offset {} unflushed segments {}", (Object)this.flushOffset, (Object)this.unflushedSegments.size());
                this.ensureSegment(segment, this.flushOffset);
                StackedSegment oldSegment = this.unflushedSegments.remove(0);
                if (oldSegment.isComplete()) {
                    this.uncompletedSegments.remove(oldSegment);
                    oldSegment.recycle();
                }
                segment = this.unflushedSegments.get(0);
                this.uncompletedSegments.add(segment);
                if (this.shutdownOffset != null) {
                    this.shutdownOffset = this.shutdownOffset - 4096;
                }
                this.firstSegment = segment;
                this.flushOffset = 0;
                LOG.debug("Queue {} flush moved to segment {}", (Object)this, (Object)segment);
            }
        }
        return entries;
    }

    boolean pairRequest(OfHeader message) {
        Iterator<StackedSegment> it = this.uncompletedSegments.iterator();
        while (it.hasNext()) {
            StackedSegment queue = it.next();
            OutboundQueueEntry entry = queue.pairRequest(message);
            if (entry == null) continue;
            LOG.trace("Queue {} accepted response {}", (Object)queue, (Object)message);
            if (entry.isBarrier() && this.uncompletedSegments.size() > 1) {
                StackedSegment q;
                LOG.trace("Queue {} indicated request was a barrier", (Object)queue);
                it = this.uncompletedSegments.iterator();
                while (it.hasNext() && !queue.equals(q = it.next())) {
                    LOG.trace("Queue {} is implied finished", (Object)q);
                    q.completeAll();
                    it.remove();
                    q.recycle();
                }
            }
            if (queue.isComplete()) {
                LOG.trace("Queue {} is finished", (Object)queue);
                it.remove();
                queue.recycle();
            }
            return true;
        }
        LOG.debug("Failed to find completion for message {}", (Object)message);
        return false;
    }

    boolean needsFlush() {
        if (this.firstSegment.getBaseXid() + (long)this.flushOffset > this.lastXid) {
            return false;
        }
        if (this.shutdownOffset != null && this.flushOffset >= this.shutdownOffset) {
            return false;
        }
        return this.firstSegment.getEntry(this.flushOffset).isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long startShutdown(Channel channel) {
        List<StackedSegment> list = this.unflushedSegments;
        synchronized (list) {
            long xid = LAST_XID_OFFSET_UPDATER.addAndGet(this, 4096L);
            this.shutdownOffset = (int)(xid - this.firstSegment.getBaseXid() - 4096L);
            return this.lockedFailSegments(this.uncompletedSegments.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finishShutdown() {
        boolean needsFlush;
        List<StackedSegment> list = this.unflushedSegments;
        synchronized (list) {
            this.lockedFailSegments(this.uncompletedSegments.iterator());
            needsFlush = this.needsFlush();
            if (!needsFlush) {
                this.lockedFailSegments(this.unflushedSegments.iterator());
            }
        }
        return !needsFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutboundQueueEntry getEntry(Long xid) {
        StackedSegment fastSegment = this.firstSegment;
        long calcOffset = xid - fastSegment.getBaseXid();
        Preconditions.checkArgument((calcOffset >= 0L ? 1 : 0) != 0, (String)"Commit of XID %s does not match up with base XID %s", (Object[])new Object[]{xid, fastSegment.getBaseXid()});
        Verify.verify((calcOffset <= Integer.MAX_VALUE ? 1 : 0) != 0);
        int fastOffset = (int)calcOffset;
        if (fastOffset >= 4096) {
            StackedSegment segment;
            int slowOffset;
            LOG.debug("Queue {} falling back to slow commit of XID {} at offset {}", new Object[]{this, xid, fastOffset});
            List<StackedSegment> list = this.unflushedSegments;
            synchronized (list) {
                StackedSegment slowSegment = this.firstSegment;
                long slowCalcOffset = xid - slowSegment.getBaseXid();
                Verify.verify((slowCalcOffset >= 0L && slowCalcOffset <= Integer.MAX_VALUE ? 1 : 0) != 0);
                slowOffset = (int)slowCalcOffset;
                LOG.debug("Queue {} recalculated offset of XID {} to {}", new Object[]{this, xid, slowOffset});
                segment = this.unflushedSegments.get(slowOffset / 4096);
            }
            int segOffset = slowOffset % 4096;
            LOG.debug("Queue {} slow commit of XID {} completed at offset {} (segment {} offset {})", new Object[]{this, xid, slowOffset, segment, segOffset});
            return segment.getEntry(segOffset);
        }
        return fastSegment.getEntry(fastOffset);
    }

    @GuardedBy(value="unflushedSegments")
    private long lockedFailSegments(Iterator<StackedSegment> iterator) {
        long entries = 0L;
        while (iterator.hasNext()) {
            StackedSegment segment = iterator.next();
            entries += (long)segment.failAll(OutboundQueueException.DEVICE_DISCONNECTED);
            if (!segment.isComplete()) continue;
            LOG.trace("Cleared segment {}", (Object)segment);
            iterator.remove();
        }
        return entries;
    }
}

