/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueHandler;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueHandlerRegistration;
import org.opendaylight.openflowjava.protocol.impl.core.OFVersionDetector;
import org.opendaylight.openflowjava.protocol.impl.core.PipelineHandlers;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractConnectionAdapterStatistics;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractOutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueHandlerRegistrationImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueManagerNoBarrier;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OpenflowProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAdapterImpl
extends AbstractConnectionAdapterStatistics
implements ConnectionFacade {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionAdapterImpl.class);
    private ConnectionReadyListener connectionReadyListener;
    private OpenflowProtocolListener messageListener;
    private SystemNotificationsListener systemListener;
    private AbstractOutboundQueueManager<?, ?> outputManager;
    private OFVersionDetector versionDetector;
    private final boolean useBarrier;

    public ConnectionAdapterImpl(Channel channel, InetSocketAddress address, boolean useBarrier) {
        super(channel, address);
        this.useBarrier = useBarrier;
        LOG.debug("ConnectionAdapter created");
    }

    public void setMessageListener(OpenflowProtocolListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setConnectionReadyListener(ConnectionReadyListener connectionReadyListener) {
        this.connectionReadyListener = connectionReadyListener;
    }

    public void setSystemListener(SystemNotificationsListener systemListener) {
        this.systemListener = systemListener;
    }

    @Override
    public void consumeDeviceMessage(DataObject message) {
        LOG.debug("ConsumeIntern msg on {}", (Object)this.channel);
        if (this.disconnectOccured) {
            return;
        }
        if (message instanceof Notification) {
            if (message instanceof DisconnectEvent) {
                this.systemListener.onDisconnectEvent((DisconnectEvent)message);
                this.responseCache.invalidateAll();
                this.disconnectOccured = true;
            } else if (message instanceof SwitchIdleEvent) {
                this.systemListener.onSwitchIdleEvent((SwitchIdleEvent)message);
            } else if (message instanceof EchoRequestMessage) {
                if (this.outputManager != null) {
                    this.outputManager.onEchoRequest((EchoRequestMessage)message);
                } else {
                    this.messageListener.onEchoRequestMessage((EchoRequestMessage)message);
                }
            } else if (message instanceof ErrorMessage) {
                if (this.outputManager == null || !this.outputManager.onMessage((OfHeader)message)) {
                    this.messageListener.onErrorMessage((ErrorMessage)message);
                }
            } else if (message instanceof ExperimenterMessage) {
                if (this.outputManager != null) {
                    this.outputManager.onMessage((OfHeader)message);
                }
                this.messageListener.onExperimenterMessage((ExperimenterMessage)message);
            } else if (message instanceof FlowRemovedMessage) {
                this.messageListener.onFlowRemovedMessage((FlowRemovedMessage)message);
            } else if (message instanceof HelloMessage) {
                LOG.info("Hello received / branch");
                this.messageListener.onHelloMessage((HelloMessage)message);
            } else if (message instanceof MultipartReplyMessage) {
                if (this.outputManager != null) {
                    this.outputManager.onMessage((OfHeader)message);
                }
                this.messageListener.onMultipartReplyMessage((MultipartReplyMessage)message);
            } else if (message instanceof PacketInMessage) {
                this.messageListener.onPacketInMessage((PacketInMessage)message);
            } else if (message instanceof PortStatusMessage) {
                this.messageListener.onPortStatusMessage((PortStatusMessage)message);
            } else {
                LOG.warn("message listening not supported for type: {}", message.getClass());
            }
        } else if (message instanceof OfHeader) {
            LOG.debug("OFheader msg received");
            if (this.outputManager == null || !this.outputManager.onMessage((OfHeader)message)) {
                RpcResponseKey key = ConnectionAdapterImpl.createRpcResponseKey((OfHeader)message);
                ResponseExpectedRpcListener<?> listener = this.findRpcResponse(key);
                if (listener != null) {
                    LOG.debug("corresponding rpcFuture found");
                    listener.completed((OfHeader)message);
                    LOG.debug("after setting rpcFuture");
                    this.responseCache.invalidate((Object)key);
                } else {
                    LOG.warn("received unexpected rpc response: {}", (Object)key);
                }
            }
        } else {
            LOG.warn("message listening not supported for type: {}", message.getClass());
        }
    }

    private static RpcResponseKey createRpcResponseKey(OfHeader message) {
        return new RpcResponseKey(message.getXid(), message.getImplementedInterface().getName());
    }

    public void checkListeners() {
        StringBuilder buffer = new StringBuilder();
        if (this.systemListener == null) {
            buffer.append("SystemListener ");
        }
        if (this.messageListener == null) {
            buffer.append("MessageListener ");
        }
        if (this.connectionReadyListener == null) {
            buffer.append("ConnectionReadyListener ");
        }
        Preconditions.checkState((buffer.length() == 0 ? 1 : 0) != 0, (String)"Missing listeners: %s", (Object[])new Object[]{buffer.toString()});
    }

    public void fireConnectionReadyNotification() {
        this.versionDetector = (OFVersionDetector)this.channel.pipeline().get(PipelineHandlers.OF_VERSION_DETECTOR.name());
        Preconditions.checkState((this.versionDetector != null ? 1 : 0) != 0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionAdapterImpl.this.connectionReadyListener.onConnectionReady();
            }
        }).start();
    }

    public <T extends OutboundQueueHandler> OutboundQueueHandlerRegistration<T> registerOutboundQueueHandler(T handler, int maxQueueDepth, long maxBarrierNanos) {
        AbstractOutboundQueueManager ret;
        Preconditions.checkState((this.outputManager == null ? 1 : 0) != 0, (String)"Manager %s already registered", (Object[])new Object[]{this.outputManager});
        if (this.useBarrier) {
            ret = new OutboundQueueManager<T>(this, this.address, handler, maxQueueDepth, maxBarrierNanos);
        } else {
            LOG.warn("OutboundQueueManager without barrier is started.");
            ret = new OutboundQueueManagerNoBarrier<T>(this, this.address, handler);
        }
        this.outputManager = ret;
        this.channel.pipeline().remove((ChannelHandler)this.output);
        this.channel.pipeline().addBefore(PipelineHandlers.DELEGATING_INBOUND_HANDLER.name(), PipelineHandlers.CHANNEL_OUTBOUND_QUEUE_MANAGER.name(), this.outputManager);
        return new OutboundQueueHandlerRegistrationImpl<T>(handler){

            protected void removeRegistration() {
                ConnectionAdapterImpl.this.outputManager.close();
                ConnectionAdapterImpl.this.channel.pipeline().remove((ChannelHandler)ConnectionAdapterImpl.this.outputManager);
                ConnectionAdapterImpl.this.outputManager = null;
            }
        };
    }

    Channel getChannel() {
        return this.channel;
    }

    public void setPacketInFiltering(boolean enabled) {
        this.versionDetector.setFilterPacketIns(enabled);
        LOG.debug("PacketIn filtering {}abled", (Object)(enabled ? "en" : "dis"));
    }
}

