/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutboundQueueEntry {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundQueueEntry.class);
    private FutureCallback<OfHeader> callback;
    private OfHeader message;
    private boolean completed;
    private boolean barrier;
    private volatile boolean committed;

    OutboundQueueEntry() {
    }

    void commit(OfHeader message, FutureCallback<OfHeader> callback) {
        this.message = message;
        this.callback = callback;
        this.barrier = message instanceof BarrierInput;
        this.committed = true;
    }

    void reset() {
        this.barrier = false;
        this.callback = null;
        this.completed = false;
        this.message = null;
        this.committed = false;
    }

    boolean isBarrier() {
        return this.barrier;
    }

    boolean isCommitted() {
        return this.committed;
    }

    boolean isCompleted() {
        return this.completed;
    }

    OfHeader takeMessage() {
        OfHeader ret = this.message;
        if (!this.barrier) {
            this.checkCompletionNeed();
        }
        this.message = null;
        return ret;
    }

    private void checkCompletionNeed() {
        if (this.callback == null || this.message instanceof PacketOutInput) {
            this.completed = true;
            if (this.callback != null) {
                this.callback.onSuccess(null);
                this.callback = null;
            }
            this.committed = false;
        }
    }

    boolean complete(OfHeader response) {
        boolean reallyComplete;
        Preconditions.checkState((!this.completed ? 1 : 0) != 0, (String)"Attempted to complete a completed message with response %s", (Object[])new Object[]{response});
        if (response instanceof MultipartReplyMessage) {
            reallyComplete = ((MultipartReplyMessage)response).getFlags().isOFPMPFREQMORE() == false;
            LOG.debug("Multipart reply {}", (Object)response);
        } else {
            reallyComplete = true;
        }
        this.completed = reallyComplete;
        if (this.callback != null) {
            this.callback.onSuccess((Object)response);
            if (reallyComplete) {
                this.callback = null;
            }
        }
        LOG.debug("Entry {} completed {} with response {}", new Object[]{this, this.completed, response});
        return reallyComplete;
    }

    void fail(OutboundQueueException cause) {
        if (!this.completed) {
            this.completed = true;
            if (this.callback != null) {
                this.callback.onFailure((Throwable)cause);
                this.callback = null;
            }
        } else {
            LOG.warn("Ignoring failure {} for completed message", (Throwable)cause);
        }
    }
}

