/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueHandler;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractOutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.StackedOutboundQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutboundQueueManager<T extends OutboundQueueHandler>
extends AbstractOutboundQueueManager<T, StackedOutboundQueue> {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundQueueManager.class);
    private final int maxNonBarrierMessages;
    private final long maxBarrierNanos;
    private boolean barrierTimerEnabled;
    private long lastBarrierNanos = System.nanoTime();
    private int nonBarrierMessages;
    private final Runnable barrierRunnable = new Runnable(){

        @Override
        public void run() {
            OutboundQueueManager.this.barrier();
        }
    };

    OutboundQueueManager(ConnectionAdapterImpl parent, InetSocketAddress address, T handler, int maxNonBarrierMessages, long maxBarrierNanos) {
        super(parent, address, handler);
        Preconditions.checkArgument((maxNonBarrierMessages > 0 ? 1 : 0) != 0);
        this.maxNonBarrierMessages = maxNonBarrierMessages;
        Preconditions.checkArgument((maxBarrierNanos > 0L ? 1 : 0) != 0);
        this.maxBarrierNanos = maxBarrierNanos;
    }

    @Override
    protected StackedOutboundQueue initializeStackedOutboudnqueue() {
        return new StackedOutboundQueue(this);
    }

    private void scheduleBarrierTimer(long now) {
        long next = this.lastBarrierNanos + this.maxBarrierNanos;
        if (next < now) {
            LOG.trace("Attempted to schedule barrier in the past, reset maximum)");
            next = now + this.maxBarrierNanos;
        }
        long delay = next - now;
        LOG.trace("Scheduling barrier timer {}us from now", (Object)TimeUnit.NANOSECONDS.toMicros(delay));
        this.parent.getChannel().eventLoop().schedule(this.barrierRunnable, next - now, TimeUnit.NANOSECONDS);
        this.barrierTimerEnabled = true;
    }

    private void scheduleBarrierMessage() {
        Long xid = ((StackedOutboundQueue)this.currentQueue).reserveBarrierIfNeeded();
        if (xid == null) {
            LOG.trace("Queue {} already contains a barrier, not scheduling one", (Object)this.currentQueue);
            return;
        }
        ((StackedOutboundQueue)this.currentQueue).commitEntry(xid, (OfHeader)this.getHandler().createBarrierRequest(xid), null);
        LOG.trace("Barrier XID {} scheduled", (Object)xid);
    }

    protected void barrier() {
        LOG.debug("Channel {} barrier timer expired", (Object)this.parent.getChannel());
        this.barrierTimerEnabled = false;
        if (this.shuttingDown) {
            LOG.trace("Channel shut down, not processing barrier");
            return;
        }
        if (((StackedOutboundQueue)this.currentQueue).isBarrierNeeded()) {
            LOG.trace("Sending a barrier message");
            this.scheduleBarrierMessage();
        } else {
            LOG.trace("Barrier not needed, not issuing one");
        }
    }

    @Override
    void writeMessage(OfHeader message, long now) {
        super.writeMessage(message, now);
        if (message instanceof BarrierInput) {
            LOG.trace("Barrier message seen, resetting counters");
            this.nonBarrierMessages = 0;
            this.lastBarrierNanos = now;
        } else {
            ++this.nonBarrierMessages;
            if (this.nonBarrierMessages >= this.maxNonBarrierMessages) {
                LOG.trace("Scheduled barrier request after {} non-barrier messages", (Object)this.nonBarrierMessages);
                this.scheduleBarrierMessage();
            } else if (!this.barrierTimerEnabled) {
                this.scheduleBarrierTimer(now);
            }
        }
    }
}

