/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractOutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractStackedOutboundQueue;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StackedOutboundQueue
extends AbstractStackedOutboundQueue {
    private static final Logger LOG = LoggerFactory.getLogger(StackedOutboundQueue.class);
    private static final AtomicLongFieldUpdater<StackedOutboundQueue> BARRIER_XID_UPDATER = AtomicLongFieldUpdater.newUpdater(StackedOutboundQueue.class, "barrierXid");
    private volatile long barrierXid = -1L;

    StackedOutboundQueue(AbstractOutboundQueueManager<?, ?> manager) {
        super(manager);
    }

    public void commitEntry(Long xid, OfHeader message, FutureCallback<OfHeader> callback) {
        OutboundQueueEntry entry = this.getEntry(xid);
        entry.commit(message, callback);
        if (entry.isBarrier()) {
            long my = xid;
            while (true) {
                long prev;
                if ((prev = BARRIER_XID_UPDATER.getAndSet(this, my)) < my) {
                    LOG.debug("Queue {} recorded pending barrier XID {}", (Object)this, (Object)my);
                    break;
                }
                LOG.debug("Queue {} retry pending barrier {} >= {}", new Object[]{this, prev, my});
                my = prev;
            }
        }
        LOG.trace("Queue {} committed XID {}", (Object)this, (Object)xid);
        this.manager.ensureFlushing();
    }

    Long reserveBarrierIfNeeded() {
        if (this.isBarrierNeeded()) {
            return this.reserveEntry();
        }
        return null;
    }

    boolean isBarrierNeeded() {
        long bXid = this.barrierXid;
        long fXid = this.firstSegment.getBaseXid() + (long)this.flushOffset;
        if (bXid >= fXid) {
            LOG.debug("Barrier found at XID {} (currently at {})", (Object)bXid, (Object)fXid);
            return false;
        }
        return true;
    }
}

