/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.channel.Channel;
import java.util.List;
import javax.annotation.Nonnull;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractOutboundQueueManager;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractStackedOutboundQueue;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.openflowjava.protocol.impl.core.connection.StackedSegment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackedOutboundQueueNoBarrier
extends AbstractStackedOutboundQueue {
    private static final Logger LOG = LoggerFactory.getLogger(StackedOutboundQueueNoBarrier.class);

    StackedOutboundQueueNoBarrier(AbstractOutboundQueueManager<?, ?> manager) {
        super(manager);
    }

    public void commitEntry(Long xid, OfHeader message, FutureCallback<OfHeader> callback) {
        OutboundQueueEntry entry = this.getEntry(xid);
        if (message instanceof FlowModInput) {
            callback.onSuccess(null);
            entry.commit(message, null);
        } else {
            entry.commit(message, callback);
        }
        LOG.trace("Queue {} committed XID {}", (Object)this, (Object)xid);
        this.manager.ensureFlushing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int writeEntries(@Nonnull Channel channel, long now) {
        StackedSegment segment = this.firstSegment;
        int entries = 0;
        while (channel.isWritable()) {
            OutboundQueueEntry entry = segment.getEntry(this.flushOffset);
            if (!entry.isCommitted()) {
                LOG.debug("Queue {} XID {} segment {} offset {} not committed yet", new Object[]{this, segment.getBaseXid() + (long)this.flushOffset, segment, this.flushOffset});
                break;
            }
            LOG.trace("Queue {} flushing entry at offset {}", (Object)this, (Object)this.flushOffset);
            OfHeader message = entry.takeMessage();
            ++this.flushOffset;
            ++entries;
            if (message != null) {
                this.manager.writeMessage(message, now);
            } else {
                entry.complete(null);
            }
            if (this.flushOffset < 4096) continue;
            List list = this.unflushedSegments;
            synchronized (list) {
                LOG.debug("Flush offset {} unflushed segments {}", (Object)this.flushOffset, (Object)this.unflushedSegments.size());
                this.ensureSegment(segment, this.flushOffset);
                StackedSegment oldSegment = (StackedSegment)this.unflushedSegments.remove(0);
                oldSegment.completeAll();
                this.uncompletedSegments.remove(oldSegment);
                oldSegment.recycle();
                segment = (StackedSegment)this.unflushedSegments.get(0);
                this.uncompletedSegments.add(segment);
                if (this.shutdownOffset != null) {
                    this.shutdownOffset = this.shutdownOffset - 4096;
                }
                this.firstSegment = segment;
                this.flushOffset = 0;
                LOG.debug("Queue {} flush moved to segment {}", (Object)this, (Object)segment);
            }
        }
        return entries;
    }
}

