/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableSoftReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.opendaylight.openflowjava.protocol.api.connection.DeviceRequestFailedException;
import org.opendaylight.openflowjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Error;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StackedSegment {
    static final int SEGMENT_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(StackedSegment.class);
    private static final FinalizableReferenceQueue REF_QUEUE = new FinalizableReferenceQueue();
    private static final ConcurrentLinkedDeque<QueueRef> CACHE = new ConcurrentLinkedDeque();
    private final OutboundQueueEntry[] entries;
    private final long baseXid;
    private final long endXid;
    private int lastBarrierOffset = -1;
    private int completeCount;

    StackedSegment(long baseXid, OutboundQueueEntry[] entries) {
        this.baseXid = baseXid;
        this.endXid = baseXid + 4096L;
        this.entries = (OutboundQueueEntry[])Preconditions.checkNotNull((Object)entries);
    }

    static StackedSegment create(long baseXid) {
        Reference item;
        while ((item = (Reference)((Object)CACHE.pollLast())) != null) {
            OutboundQueueEntry[] cached = (OutboundQueueEntry[])item.get();
            if (cached == null) continue;
            StackedSegment ret = new StackedSegment(baseXid, cached);
            LOG.trace("Reusing array {} in segment {}", (Object)cached, (Object)ret);
            return ret;
        }
        OutboundQueueEntry[] entries = new OutboundQueueEntry[4096];
        for (int i = 0; i < 4096; ++i) {
            entries[i] = new OutboundQueueEntry();
        }
        StackedSegment ret = new StackedSegment(baseXid, entries);
        LOG.trace("Allocated new segment {}", (Object)ret);
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseXid", this.baseXid).add("endXid", this.endXid).add("completeCount", this.completeCount).toString();
    }

    long getBaseXid() {
        return this.baseXid;
    }

    long getEndXid() {
        return this.endXid;
    }

    OutboundQueueEntry getEntry(int offset) {
        return this.entries[offset];
    }

    private boolean xidInRange(long xid) {
        return xid < this.endXid && (xid >= this.baseXid || this.baseXid > this.endXid);
    }

    private static boolean completeEntry(OutboundQueueEntry entry, OfHeader response) {
        if (response instanceof Error) {
            Error err = (Error)response;
            LOG.debug("Device-reported request XID {} failed {}:{}", new Object[]{response.getXid(), err.getTypeString(), err.getCodeString()});
            entry.fail((OutboundQueueException)new DeviceRequestFailedException("Device-side failure", err));
            return true;
        }
        return entry.complete(response);
    }

    OutboundQueueEntry findEntry(long xid) {
        if (!this.xidInRange(xid)) {
            LOG.debug("Queue {} {}/{} ignoring XID {}", new Object[]{this, this.baseXid, this.entries.length, xid});
            return null;
        }
        int offset = (int)(xid - this.baseXid);
        return this.entries[offset];
    }

    OutboundQueueEntry pairRequest(OfHeader response) {
        long xid = response.getXid();
        if (!this.xidInRange(xid)) {
            LOG.debug("Queue {} {}/{} ignoring XID {}", new Object[]{this, this.baseXid, this.entries.length, xid});
            return null;
        }
        int offset = (int)(xid - this.baseXid);
        OutboundQueueEntry entry = this.entries[offset];
        if (entry.isCompleted()) {
            LOG.debug("Entry {} already is completed, not accepting response {}", (Object)entry, (Object)response);
            return null;
        }
        if (entry.isBarrier()) {
            LOG.trace("Barrier XID {} completed, cascading completion to XIDs {} to {}", new Object[]{xid, this.baseXid + (long)this.lastBarrierOffset + 1L, xid - 1L});
            this.completeRequests(offset);
            this.lastBarrierOffset = offset;
            boolean success = StackedSegment.completeEntry(entry, response);
            Verify.verify((boolean)success, (String)"Barrier request failed to complete", (Object[])new Object[0]);
            ++this.completeCount;
        } else if (StackedSegment.completeEntry(entry, response)) {
            ++this.completeCount;
        }
        return entry;
    }

    private void completeRequests(int toOffset) {
        for (int i = this.lastBarrierOffset + 1; i < toOffset; ++i) {
            OutboundQueueEntry entry = this.entries[i];
            if (entry.isCompleted() || !entry.complete(null)) continue;
            ++this.completeCount;
        }
    }

    void completeAll() {
        this.completeRequests(this.entries.length);
    }

    int failAll(OutboundQueueException cause) {
        OutboundQueueEntry entry;
        int ret = 0;
        for (int i = this.lastBarrierOffset + 1; i < this.entries.length && (entry = this.entries[i]).isCommitted(); ++i) {
            if (entry.isCompleted()) continue;
            entry.fail(cause);
            ++ret;
        }
        return ret;
    }

    boolean isComplete() {
        return this.completeCount >= this.entries.length;
    }

    void recycle() {
        for (OutboundQueueEntry e : this.entries) {
            e.reset();
        }
        CACHE.offer(new QueueRef(REF_QUEUE, this.entries));
    }

    private static final class QueueRef
    extends FinalizableSoftReference<OutboundQueueEntry[]> {
        QueueRef(FinalizableReferenceQueue queue, OutboundQueueEntry[] referent) {
            super((Object)referent, queue);
        }

        public void finalizeReferent() {
            CACHE.remove((Object)this);
        }
    }
}

