/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.TypeToClassMapInitializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeToClassKey;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DeserializationFactory {
    private final Map<TypeToClassKey, Class<?>> messageClassMap;
    private DeserializerRegistry registry;

    public DeserializationFactory() {
        HashMap temp = new HashMap();
        TypeToClassMapInitializer.initializeTypeToClassMap(temp);
        TypeToClassMapInitializer.initializeAdditionalTypeToClassMap(temp);
        this.messageClassMap = ImmutableMap.copyOf(temp);
    }

    public DataObject deserialize(ByteBuf rawMessage, short version) {
        DataObject dataObject = null;
        short type = rawMessage.readUnsignedByte();
        Class<?> clazz = this.messageClassMap.get(new TypeToClassKey(version, type));
        rawMessage.skipBytes(2);
        OFDeserializer deserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(version, (int)type, clazz));
        dataObject = (DataObject)deserializer.deserialize(rawMessage);
        return dataObject;
    }

    public void setRegistry(DeserializerRegistry registry) {
        this.registry = registry;
    }
}

