/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.ActionDeserializerInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.AdditionalMessageDeserializerInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.InstructionDeserializerInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.MatchEntryDeserializerInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.MessageDeserializerInitializer;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.OF10MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerRegistryImpl
implements DeserializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializerRegistryImpl.class);
    private Map<MessageCodeKey, OFGeneralDeserializer> registry;

    public void init() {
        this.registry = new HashMap<MessageCodeKey, OFGeneralDeserializer>();
        MessageDeserializerInitializer.registerMessageDeserializers(this);
        AdditionalMessageDeserializerInitializer.registerMessageDeserializers(this);
        this.registerDeserializer(new MessageCodeKey(1, 0, MatchV10.class), (OFGeneralDeserializer)new OF10MatchDeserializer());
        this.registerDeserializer(new MessageCodeKey(4, 0, Match.class), (OFGeneralDeserializer)new MatchDeserializer());
        MatchEntryDeserializerInitializer.registerMatchEntryDeserializers(this);
        ActionDeserializerInitializer.registerDeserializers(this);
        InstructionDeserializerInitializer.registerDeserializers(this);
    }

    public <T extends OFGeneralDeserializer> T getDeserializer(MessageCodeKey key) {
        OFGeneralDeserializer deserializer = this.registry.get(key);
        if (deserializer == null) {
            throw new IllegalStateException("Deserializer for key: " + key + " was not found - please verify that all needed deserializers ale loaded correctly");
        }
        return (T)deserializer;
    }

    public void registerDeserializer(MessageCodeKey key, OFGeneralDeserializer deserializer) {
        if (key == null || deserializer == null) {
            throw new IllegalArgumentException("MessageCodeKey or Deserializer is null");
        }
        OFGeneralDeserializer desInRegistry = this.registry.put(key, deserializer);
        if (desInRegistry != null) {
            LOGGER.debug("Deserializer for key {} overwritten. Old deserializer: {}, new deserializer: {}", new Object[]{key, desInRegistry.getClass().getName(), deserializer.getClass().getName()});
        }
        if (deserializer instanceof DeserializerRegistryInjector) {
            ((DeserializerRegistryInjector)deserializer).injectDeserializerRegistry((DeserializerRegistry)this);
        }
    }

    public boolean unregisterDeserializer(MessageCodeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("MessageCodeKey is null");
        }
        OFGeneralDeserializer deserializer = this.registry.remove(key);
        return deserializer != null;
    }
}

