/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.ApplyActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.ClearActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.GoToTableInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.MeterInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.WriteActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.WriteMetadataInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.InstructionDeserializerRegistryHelper;

public final class InstructionDeserializerInitializer {
    private InstructionDeserializerInitializer() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static void registerDeserializers(DeserializerRegistry registry) {
        InstructionDeserializerRegistryHelper helper = new InstructionDeserializerRegistryHelper(4, registry);
        helper.registerDeserializer(1, (OFGeneralDeserializer)new GoToTableInstructionDeserializer());
        helper.registerDeserializer(2, (OFGeneralDeserializer)new WriteMetadataInstructionDeserializer());
        helper.registerDeserializer(3, (OFGeneralDeserializer)new WriteActionsInstructionDeserializer());
        helper.registerDeserializer(4, (OFGeneralDeserializer)new ApplyActionsInstructionDeserializer());
        helper.registerDeserializer(5, (OFGeneralDeserializer)new ClearActionsInstructionDeserializer());
        helper.registerDeserializer(6, (OFGeneralDeserializer)new MeterInstructionDeserializer());
    }
}

