/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.action;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.action.AbstractActionDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.field._case.SetFieldActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF13SetFieldActionDeserializer
extends AbstractActionDeserializer
implements DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    public Action deserialize(ByteBuf input) {
        ActionBuilder builder = new ActionBuilder();
        int startIndex = input.readerIndex();
        input.skipBytes(4);
        SetFieldCaseBuilder caseBuilder = new SetFieldCaseBuilder();
        SetFieldActionBuilder actionBuilder = new SetFieldActionBuilder();
        int oxmClass = input.getUnsignedShort(input.readerIndex());
        int oxmField = input.getUnsignedByte(input.readerIndex() + 2) >>> 1;
        MatchEntryDeserializerKey key = new MatchEntryDeserializerKey(4, oxmClass, oxmField);
        if (oxmClass == 65535) {
            long expId = input.getUnsignedInt(input.readerIndex() + 2 + 2);
            key.setExperimenterId(Long.valueOf(expId));
        }
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)key);
        ArrayList<DataContainer> entry = new ArrayList<DataContainer>();
        entry.add(matchDeserializer.deserialize(input));
        actionBuilder.setMatchEntry(entry);
        caseBuilder.setSetFieldAction(actionBuilder.build());
        builder.setActionChoice((ActionChoice)caseBuilder.build());
        int paddingRemainder = (input.readerIndex() - startIndex) % 8;
        if (paddingRemainder != 0) {
            input.skipBytes(8 - paddingRemainder);
        }
        return builder.build();
    }

    @Override
    protected ActionChoice getType() {
        return new SetFieldCaseBuilder().build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

