/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutputBuilder;

public class FeaturesReplyMessageFactory
implements OFDeserializer<GetFeaturesOutput> {
    private static final byte PADDING_IN_FEATURES_REPLY_HEADER = 2;

    public GetFeaturesOutput deserialize(ByteBuf rawMessage) {
        GetFeaturesOutputBuilder builder = new GetFeaturesOutputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] datapathId = new byte[8];
        rawMessage.readBytes(datapathId);
        builder.setDatapathId(new BigInteger(1, datapathId));
        builder.setBuffers(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTables(Short.valueOf(rawMessage.readUnsignedByte()));
        builder.setAuxiliaryId(Short.valueOf(rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(2);
        builder.setCapabilities(FeaturesReplyMessageFactory.createCapabilities(rawMessage.readUnsignedInt()));
        builder.setReserved(Long.valueOf(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static Capabilities createCapabilities(long input) {
        Boolean flowStats = (input & 1L) != 0L;
        Boolean tableStats = (input & 2L) != 0L;
        Boolean portStats = (input & 4L) != 0L;
        Boolean groupStats = (input & 8L) != 0L;
        Boolean ipReasm = (input & 0x20L) != 0L;
        Boolean queueStats = (input & 0x40L) != 0L;
        Boolean portBlocked = (input & 0x100L) != 0L;
        return new Capabilities(flowStats, groupStats, ipReasm, portBlocked, portStats, queueStats, tableStats);
    }
}

