/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;

public class FlowModInputMessageFactory
implements OFDeserializer<FlowModInput>,
DeserializerRegistryInjector {
    private static final byte PADDING = 2;
    private DeserializerRegistry registry;

    public FlowModInput deserialize(ByteBuf rawMessage) {
        FlowModInputBuilder builder = new FlowModInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookie_mask = new byte[8];
        rawMessage.readBytes(cookie_mask);
        builder.setCookieMask(new BigInteger(1, cookie_mask));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        builder.setCommand(FlowModCommand.forValue((int)rawMessage.readUnsignedByte()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setHardTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setOutPort(new PortNumber(Long.valueOf(rawMessage.readUnsignedInt())));
        builder.setOutGroup(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setFlags(FlowModInputMessageFactory.createFlowModFlagsFromBitmap(rawMessage.readUnsignedShort()));
        rawMessage.skipBytes(2);
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
        builder.setMatch((Match)matchDeserializer.deserialize(rawMessage));
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
        List instructions = ListDeserializer.deserializeList((short)4, rawMessage.readableBytes(), rawMessage, keyMaker, this.registry);
        builder.setInstruction(instructions);
        return builder.build();
    }

    private static FlowModFlags createFlowModFlagsFromBitmap(int input) {
        Boolean _oFPFFSENDFLOWREM = (input & 1) > 0;
        Boolean _oFPFFCHECKOVERLAP = (input & 2) > 0;
        Boolean _oFPFFRESETCOUNTS = (input & 4) > 0;
        Boolean _oFPFFNOPKTCOUNTS = (input & 8) > 0;
        Boolean _oFPFFNOBYTCOUNTS = (input & 0x10) > 0;
        return new FlowModFlags(_oFPFFCHECKOVERLAP, _oFPFFNOBYTCOUNTS, _oFPFFNOPKTCOUNTS, _oFPFFRESETCOUNTS, _oFPFFSENDFLOWREM);
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

