/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;

public class FlowRemovedMessageFactory
implements OFDeserializer<FlowRemovedMessage>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    public FlowRemovedMessage deserialize(ByteBuf rawMessage) {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(FlowRemovedReason.forValue((int)rawMessage.readUnsignedByte()));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        builder.setDurationSec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setDurationNsec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setHardTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        byte[] packetCount = new byte[8];
        rawMessage.readBytes(packetCount);
        builder.setPacketCount(new BigInteger(1, packetCount));
        byte[] byteCount = new byte[8];
        rawMessage.readBytes(byteCount);
        builder.setByteCount(new BigInteger(1, byteCount));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
        builder.setMatch((Match)matchDeserializer.deserialize(rawMessage));
        return builder.build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

