/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsListBuilder;

public class GroupModInputMessageFactory
implements OFDeserializer<GroupModInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;
    private static final byte PADDING = 1;
    private static final byte PADDING_IN_BUCKETS_HEADER = 4;
    private static final byte BUCKETS_HEADER_LENGTH = 16;

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }

    public GroupModInput deserialize(ByteBuf rawMessage) {
        GroupModInputBuilder builder = new GroupModInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setCommand(GroupModCommand.forValue((int)rawMessage.readUnsignedShort()));
        builder.setType(GroupType.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        builder.setGroupId(new GroupId(Long.valueOf(rawMessage.readUnsignedInt())));
        ArrayList<BucketsList> bucketsList = new ArrayList<BucketsList>();
        while (rawMessage.readableBytes() > 0) {
            BucketsListBuilder bucketsBuilder = new BucketsListBuilder();
            int bucketsLength = rawMessage.readUnsignedShort();
            bucketsBuilder.setWeight(Integer.valueOf(rawMessage.readUnsignedShort()));
            bucketsBuilder.setWatchPort(new PortNumber(Long.valueOf(rawMessage.readUnsignedInt())));
            bucketsBuilder.setWatchGroup(Long.valueOf(rawMessage.readUnsignedInt()));
            rawMessage.skipBytes(4);
            CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
            List actions = ListDeserializer.deserializeList((short)4, bucketsLength - 16, rawMessage, keyMaker, this.registry);
            bucketsBuilder.setAction(actions);
            bucketsList.add(bucketsBuilder.build());
        }
        builder.setBucketsList(bucketsList);
        return builder.build();
    }
}

