/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.ElementsBuilder;

public class HelloMessageFactory
implements OFDeserializer<HelloMessage> {
    private static final byte HELLO_ELEMENT_HEADER_SIZE = 4;

    public HelloMessage deserialize(ByteBuf rawMessage) {
        HelloMessageBuilder builder = new HelloMessageBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        if (rawMessage.readableBytes() > 0) {
            builder.setElements(HelloMessageFactory.readElement(rawMessage));
        }
        return builder.build();
    }

    private static List<Elements> readElement(ByteBuf input) {
        ArrayList<Elements> elementsList = new ArrayList<Elements>();
        while (input.readableBytes() > 0) {
            ElementsBuilder elementsBuilder = new ElementsBuilder();
            int type = input.readUnsignedShort();
            int elementLength = input.readUnsignedShort();
            if (type == HelloElementType.VERSIONBITMAP.getIntValue()) {
                elementsBuilder.setType(HelloElementType.forValue((int)type));
                int[] versionBitmap = new int[(elementLength - 4) / 4];
                for (int i = 0; i < versionBitmap.length; ++i) {
                    versionBitmap[i] = (int)input.readUnsignedInt();
                }
                elementsBuilder.setVersionBitmap(HelloMessageFactory.readVersionBitmap(versionBitmap));
                int paddingRemainder = elementLength % 8;
                if (paddingRemainder != 0) {
                    input.readBytes(8 - paddingRemainder);
                }
            } else {
                return elementsList;
            }
            elementsList.add(elementsBuilder.build());
        }
        return elementsList;
    }

    private static List<Boolean> readVersionBitmap(int[] input) {
        ArrayList<Boolean> versionBitmapList = new ArrayList<Boolean>();
        for (int i = 0; i < input.length; ++i) {
            int mask = input[i];
            for (int j = 0; j < 32; ++j) {
                versionBitmapList.add((mask & 1 << j) != 0);
            }
        }
        return versionBitmapList;
    }
}

