/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.util.ExperimenterDeserializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.BandsBuilder;

public class MeterModInputMessageFactory
implements OFDeserializer<MeterModInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;
    private static final byte PADDING_IN_METER_BAND_DROP_HEADER = 4;
    private static final byte PADDING_IN_METER_BAND_DSCP_HEADER = 3;

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }

    public MeterModInput deserialize(ByteBuf rawMessage) {
        MeterModInputBuilder builder = new MeterModInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setCommand(MeterModCommand.forValue((int)rawMessage.readUnsignedShort()));
        builder.setFlags(MeterModInputMessageFactory.createMeterFlags(rawMessage.readUnsignedShort()));
        builder.setMeterId(new MeterId(Long.valueOf(rawMessage.readUnsignedInt())));
        ArrayList<Bands> bandsList = new ArrayList<Bands>();
        while (rawMessage.readableBytes() > 0) {
            BandsBuilder bandsBuilder = new BandsBuilder();
            int bandStartIndex = rawMessage.readerIndex();
            int bandType = rawMessage.readUnsignedShort();
            switch (bandType) {
                case 1: {
                    MeterBandDropCaseBuilder bandDropCaseBuilder = new MeterBandDropCaseBuilder();
                    MeterBandDropBuilder bandDropBuilder = new MeterBandDropBuilder();
                    bandDropBuilder.setType(MeterBandType.forValue((int)bandType));
                    rawMessage.readUnsignedShort();
                    bandDropBuilder.setRate(Long.valueOf(rawMessage.readUnsignedInt()));
                    bandDropBuilder.setBurstSize(Long.valueOf(rawMessage.readUnsignedInt()));
                    rawMessage.skipBytes(4);
                    bandDropCaseBuilder.setMeterBandDrop(bandDropBuilder.build());
                    bandsBuilder.setMeterBand((MeterBand)bandDropCaseBuilder.build());
                    break;
                }
                case 2: {
                    MeterBandDscpRemarkCaseBuilder bandDscpRemarkCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
                    MeterBandDscpRemarkBuilder bandDscpRemarkBuilder = new MeterBandDscpRemarkBuilder();
                    bandDscpRemarkBuilder.setType(MeterBandType.forValue((int)bandType));
                    rawMessage.readUnsignedShort();
                    bandDscpRemarkBuilder.setRate(Long.valueOf(rawMessage.readUnsignedInt()));
                    bandDscpRemarkBuilder.setBurstSize(Long.valueOf(rawMessage.readUnsignedInt()));
                    bandDscpRemarkBuilder.setPrecLevel(Short.valueOf(rawMessage.readUnsignedByte()));
                    rawMessage.skipBytes(3);
                    bandDscpRemarkCaseBuilder.setMeterBandDscpRemark(bandDscpRemarkBuilder.build());
                    bandsBuilder.setMeterBand((MeterBand)bandDscpRemarkCaseBuilder.build());
                    break;
                }
                case 65535: {
                    long expId = rawMessage.getUnsignedInt(rawMessage.readerIndex() + 8);
                    rawMessage.readerIndex(bandStartIndex);
                    OFDeserializer deserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createMeterBandDeserializerKey((short)4, (Long)expId));
                    bandsBuilder.setMeterBand((MeterBand)deserializer.deserialize(rawMessage));
                }
            }
            bandsList.add(bandsBuilder.build());
        }
        builder.setBands(bandsList);
        return builder.build();
    }

    private static MeterFlags createMeterFlags(int input) {
        Boolean mfKBPS = (input & 1) != 0;
        Boolean mfPKTPS = (input & 2) != 0;
        Boolean mfBURST = (input & 4) != 0;
        Boolean mfSTATS = (input & 8) != 0;
        return new MeterFlags(mfBURST, mfKBPS, mfPKTPS, mfSTATS);
    }
}

