/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterDeserializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIdsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.experimenter._case.MultipartReplyExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.BandsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.PortsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeaturePropertiesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultipartReplyMessageFactory
implements OFDeserializer<MultipartReplyMessage>,
DeserializerRegistryInjector {
    private static final byte PADDING_IN_MULTIPART_REPLY_HEADER = 4;
    private static final int DESC_STR_LEN = 256;
    private static final int SERIAL_NUM_LEN = 32;
    private static final byte PADDING_IN_FLOW_STATS_HEADER_01 = 1;
    private static final byte PADDING_IN_FLOW_STATS_HEADER_02 = 4;
    private static final byte PADDING_IN_AGGREGATE_HEADER = 4;
    private static final byte PADDING_IN_TABLE_HEADER = 3;
    private static final byte PADDING_IN_MULTIPART_REPLY_TABLE_FEATURES = 5;
    private static final byte MAX_TABLE_NAME_LENGTH = 32;
    private static final byte MULTIPART_REPLY_TABLE_FEATURES_STRUCTURE_LENGTH = 64;
    private static final byte COMMON_PROPERTY_LENGTH = 4;
    private static final byte PADDING_IN_PORT_STATS_HEADER = 4;
    private static final byte PADDING_IN_GROUP_HEADER_01 = 2;
    private static final byte PADDING_IN_GROUP_HEADER_02 = 4;
    private static final byte BUCKET_COUNTER_LENGTH = 16;
    private static final byte GROUP_BODY_LENGTH = 40;
    private static final byte PADDING_IN_METER_FEATURES_HEADER = 2;
    private static final byte PADDING_IN_METER_STATS_HEADER = 6;
    private static final byte METER_BAND_STATS_LENGTH = 16;
    private static final byte METER_BODY_LENGTH = 40;
    private static final byte METER_CONFIG_LENGTH = 8;
    private static final byte PADDING_IN_METER_BAND_DROP_HEADER = 4;
    private static final byte PADDING_IN_METER_BAND_DSCP_HEADER = 3;
    private static final byte PADDING_IN_PORT_DESC_HEADER_01 = 4;
    private static final byte PADDING_IN_PORT_DESC_HEADER_02 = 2;
    private static final int GROUP_TYPES = 4;
    private static final byte PADDING_IN_GROUP_DESC_HEADER = 1;
    private static final byte PADDING_IN_BUCKETS_HEADER = 4;
    private static final byte GROUP_DESC_HEADER_LENGTH = 8;
    private static final byte BUCKETS_HEADER_LENGTH = 16;
    private DeserializerRegistry registry;

    public MultipartReplyMessage deserialize(ByteBuf rawMessage) {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        builder.setType(MultipartType.forValue((int)type));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf((rawMessage.readUnsignedShort() & 1) != 0)));
        rawMessage.skipBytes(4);
        switch (MultipartType.forValue((int)type)) {
            case OFPMPDESC: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setDesc(rawMessage));
                break;
            }
            case OFPMPFLOW: {
                builder.setMultipartReplyBody((MultipartReplyBody)this.setFlow(rawMessage));
                break;
            }
            case OFPMPAGGREGATE: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setAggregate(rawMessage));
                break;
            }
            case OFPMPTABLE: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setTable(rawMessage));
                break;
            }
            case OFPMPPORTSTATS: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setPortStats(rawMessage));
                break;
            }
            case OFPMPQUEUE: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setQueue(rawMessage));
                break;
            }
            case OFPMPGROUP: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setGroup(rawMessage));
                break;
            }
            case OFPMPGROUPDESC: {
                builder.setMultipartReplyBody((MultipartReplyBody)this.setGroupDesc(rawMessage));
                break;
            }
            case OFPMPGROUPFEATURES: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setGroupFeatures(rawMessage));
                break;
            }
            case OFPMPMETER: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setMeter(rawMessage));
                break;
            }
            case OFPMPMETERCONFIG: {
                builder.setMultipartReplyBody((MultipartReplyBody)this.setMeterConfig(rawMessage));
                break;
            }
            case OFPMPMETERFEATURES: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setMeterFeatures(rawMessage));
                break;
            }
            case OFPMPTABLEFEATURES: {
                builder.setMultipartReplyBody((MultipartReplyBody)this.setTableFeatures(rawMessage));
                break;
            }
            case OFPMPPORTDESC: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setPortDesc(rawMessage));
                break;
            }
            case OFPMPEXPERIMENTER: {
                builder.setMultipartReplyBody((MultipartReplyBody)this.setExperimenter(rawMessage));
                break;
            }
        }
        return builder.build();
    }

    private static MultipartReplyDescCase setDesc(ByteBuf input) {
        MultipartReplyDescCaseBuilder caseBuilder = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder descBuilder = new MultipartReplyDescBuilder();
        byte[] mfrDescBytes = new byte[256];
        input.readBytes(mfrDescBytes);
        String mfrDesc = new String(mfrDescBytes);
        descBuilder.setMfrDesc(mfrDesc.trim());
        byte[] hwDescBytes = new byte[256];
        input.readBytes(hwDescBytes);
        String hwDesc = new String(hwDescBytes);
        descBuilder.setHwDesc(hwDesc.trim());
        byte[] swDescBytes = new byte[256];
        input.readBytes(swDescBytes);
        String swDesc = new String(swDescBytes);
        descBuilder.setSwDesc(swDesc.trim());
        byte[] serialNumBytes = new byte[32];
        input.readBytes(serialNumBytes);
        String serialNum = new String(serialNumBytes);
        descBuilder.setSerialNum(serialNum.trim());
        byte[] dpDescBytes = new byte[256];
        input.readBytes(dpDescBytes);
        String dpDesc = new String(dpDescBytes);
        descBuilder.setDpDesc(dpDesc.trim());
        caseBuilder.setMultipartReplyDesc(descBuilder.build());
        return caseBuilder.build();
    }

    private MultipartReplyFlowCase setFlow(ByteBuf input) {
        MultipartReplyFlowCaseBuilder caseBuilder = new MultipartReplyFlowCaseBuilder();
        MultipartReplyFlowBuilder flowBuilder = new MultipartReplyFlowBuilder();
        ArrayList<FlowStats> flowStatsList = new ArrayList<FlowStats>();
        while (input.readableBytes() > 0) {
            FlowStatsBuilder flowStatsBuilder = new FlowStatsBuilder();
            int flowRecordLength = input.readUnsignedShort();
            ByteBuf subInput = input.readSlice(flowRecordLength - 2);
            flowStatsBuilder.setTableId(Short.valueOf(subInput.readUnsignedByte()));
            subInput.skipBytes(1);
            flowStatsBuilder.setDurationSec(Long.valueOf(subInput.readUnsignedInt()));
            flowStatsBuilder.setDurationNsec(Long.valueOf(subInput.readUnsignedInt()));
            flowStatsBuilder.setPriority(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setIdleTimeout(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setHardTimeout(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setFlags(MultipartReplyMessageFactory.createFlowModFlagsFromBitmap(subInput.readUnsignedShort()));
            subInput.skipBytes(4);
            byte[] cookie = new byte[8];
            subInput.readBytes(cookie);
            flowStatsBuilder.setCookie(new BigInteger(1, cookie));
            byte[] packetCount = new byte[8];
            subInput.readBytes(packetCount);
            flowStatsBuilder.setPacketCount(new BigInteger(1, packetCount));
            byte[] byteCount = new byte[8];
            subInput.readBytes(byteCount);
            flowStatsBuilder.setByteCount(new BigInteger(1, byteCount));
            OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
            flowStatsBuilder.setMatch((Match)matchDeserializer.deserialize(subInput));
            CodeKeyMaker keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
            List instructions = ListDeserializer.deserializeList((short)4, subInput.readableBytes(), subInput, keyMaker, this.registry);
            flowStatsBuilder.setInstruction(instructions);
            flowStatsList.add(flowStatsBuilder.build());
        }
        flowBuilder.setFlowStats(flowStatsList);
        caseBuilder.setMultipartReplyFlow(flowBuilder.build());
        return caseBuilder.build();
    }

    private static FlowModFlags createFlowModFlagsFromBitmap(int input) {
        Boolean fmfSENDFLOWREM = (input & 1) != 0;
        Boolean fmfCHECKOVERLAP = (input & 2) != 0;
        Boolean fmfRESETCOUNTS = (input & 4) != 0;
        Boolean fmfNOPKTCOUNTS = (input & 8) != 0;
        Boolean fmfNOBYTCOUNTS = (input & 0x10) != 0;
        return new FlowModFlags(fmfCHECKOVERLAP, fmfNOBYTCOUNTS, fmfNOPKTCOUNTS, fmfRESETCOUNTS, fmfSENDFLOWREM);
    }

    private static MultipartReplyAggregateCase setAggregate(ByteBuf input) {
        MultipartReplyAggregateCaseBuilder caseBuilder = new MultipartReplyAggregateCaseBuilder();
        MultipartReplyAggregateBuilder builder = new MultipartReplyAggregateBuilder();
        byte[] packetCount = new byte[8];
        input.readBytes(packetCount);
        builder.setPacketCount(new BigInteger(1, packetCount));
        byte[] byteCount = new byte[8];
        input.readBytes(byteCount);
        builder.setByteCount(new BigInteger(1, byteCount));
        builder.setFlowCount(Long.valueOf(input.readUnsignedInt()));
        input.skipBytes(4);
        caseBuilder.setMultipartReplyAggregate(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyTableCase setTable(ByteBuf input) {
        MultipartReplyTableCaseBuilder caseBuilder = new MultipartReplyTableCaseBuilder();
        MultipartReplyTableBuilder builder = new MultipartReplyTableBuilder();
        ArrayList<TableStats> tableStatsList = new ArrayList<TableStats>();
        while (input.readableBytes() > 0) {
            TableStatsBuilder tableStatsBuilder = new TableStatsBuilder();
            tableStatsBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
            input.skipBytes(3);
            tableStatsBuilder.setActiveCount(Long.valueOf(input.readUnsignedInt()));
            byte[] lookupCount = new byte[8];
            input.readBytes(lookupCount);
            tableStatsBuilder.setLookupCount(new BigInteger(1, lookupCount));
            byte[] matchedCount = new byte[8];
            input.readBytes(matchedCount);
            tableStatsBuilder.setMatchedCount(new BigInteger(1, matchedCount));
            tableStatsList.add(tableStatsBuilder.build());
        }
        builder.setTableStats(tableStatsList);
        caseBuilder.setMultipartReplyTable(builder.build());
        return caseBuilder.build();
    }

    private MultipartReplyTableFeaturesCase setTableFeatures(ByteBuf input) {
        MultipartReplyTableFeaturesCaseBuilder caseBuilder = new MultipartReplyTableFeaturesCaseBuilder();
        MultipartReplyTableFeaturesBuilder builder = new MultipartReplyTableFeaturesBuilder();
        ArrayList<TableFeatures> features = new ArrayList<TableFeatures>();
        while (input.readableBytes() > 0) {
            TableFeaturesBuilder featuresBuilder = new TableFeaturesBuilder();
            int length = input.readUnsignedShort();
            featuresBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
            input.skipBytes(5);
            featuresBuilder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)input, (int)32));
            byte[] metadataMatch = new byte[8];
            input.readBytes(metadataMatch);
            featuresBuilder.setMetadataMatch(metadataMatch);
            byte[] metadataWrite = new byte[8];
            input.readBytes(metadataWrite);
            featuresBuilder.setMetadataWrite(metadataWrite);
            featuresBuilder.setConfig(MultipartReplyMessageFactory.createTableConfig(input.readUnsignedInt()));
            featuresBuilder.setMaxEntries(Long.valueOf(input.readUnsignedInt()));
            featuresBuilder.setTableFeatureProperties(this.createTableFeaturesProperties(input, length - 64));
            features.add(featuresBuilder.build());
        }
        builder.setTableFeatures(features);
        caseBuilder.setMultipartReplyTableFeatures(builder.build());
        return caseBuilder.build();
    }

    private static TableConfig createTableConfig(long input) {
        boolean deprecated = (input & 3L) != 0L;
        return new TableConfig(Boolean.valueOf(deprecated));
    }

    private List<TableFeatureProperties> createTableFeaturesProperties(ByteBuf input, int length) {
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        int tableFeaturesLength = length;
        while (tableFeaturesLength > 0) {
            CodeKeyMaker keyMaker;
            int propStartIndex = input.readerIndex();
            TableFeaturePropertiesBuilder builder = new TableFeaturePropertiesBuilder();
            TableFeaturesPropType type = TableFeaturesPropType.forValue((int)input.readUnsignedShort());
            builder.setType(type);
            int propertyLength = input.readUnsignedShort();
            int paddingRemainder = propertyLength % 8;
            tableFeaturesLength -= propertyLength;
            if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS)) {
                InstructionRelatedTableFeaturePropertyBuilder insBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
                List instructions = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                insBuilder.setInstruction(instructions);
                builder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLES) || type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS)) {
                propertyLength -= 4;
                NextTableRelatedTableFeaturePropertyBuilder tableBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
                ArrayList<NextTableIds> ids = new ArrayList<NextTableIds>();
                while (propertyLength > 0) {
                    NextTableIdsBuilder nextTableIdsBuilder = new NextTableIdsBuilder();
                    nextTableIdsBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
                    ids.add(nextTableIdsBuilder.build());
                    --propertyLength;
                }
                tableBuilder.setNextTableIds(ids);
                builder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)tableBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS)) {
                ActionRelatedTableFeaturePropertyBuilder actionBuilder = new ActionRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
                List actions = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                actionBuilder.setAction(actions);
                builder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actionBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTMATCH) || type.equals((Object)TableFeaturesPropType.OFPTFPTWILDCARDS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS)) {
                OxmRelatedTableFeaturePropertyBuilder oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
                List entries = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                oxmBuilder.setMatchEntry(entries);
                builder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTER) || type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS)) {
                long expId = input.readUnsignedInt();
                input.readerIndex(propStartIndex);
                OFDeserializer propDeserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createMultipartReplyTFDeserializerKey((short)4, (Long)expId));
                TableFeatureProperties expProp = (TableFeatureProperties)propDeserializer.deserialize(input);
                properties.add(expProp);
                continue;
            }
            if (paddingRemainder != 0) {
                input.skipBytes(8 - paddingRemainder);
                tableFeaturesLength -= 8 - paddingRemainder;
            }
            properties.add(builder.build());
        }
        return properties;
    }

    private static MultipartReplyPortStatsCase setPortStats(ByteBuf input) {
        MultipartReplyPortStatsCaseBuilder caseBuilder = new MultipartReplyPortStatsCaseBuilder();
        MultipartReplyPortStatsBuilder builder = new MultipartReplyPortStatsBuilder();
        ArrayList<PortStats> portStatsList = new ArrayList<PortStats>();
        while (input.readableBytes() > 0) {
            PortStatsBuilder portStatsBuilder = new PortStatsBuilder();
            portStatsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] rxPackets = new byte[8];
            input.readBytes(rxPackets);
            portStatsBuilder.setRxPackets(new BigInteger(1, rxPackets));
            byte[] txPackets = new byte[8];
            input.readBytes(txPackets);
            portStatsBuilder.setTxPackets(new BigInteger(1, txPackets));
            byte[] rxBytes = new byte[8];
            input.readBytes(rxBytes);
            portStatsBuilder.setRxBytes(new BigInteger(1, rxBytes));
            byte[] txBytes = new byte[8];
            input.readBytes(txBytes);
            portStatsBuilder.setTxBytes(new BigInteger(1, txBytes));
            byte[] rxDropped = new byte[8];
            input.readBytes(rxDropped);
            portStatsBuilder.setRxDropped(new BigInteger(1, rxDropped));
            byte[] txDropped = new byte[8];
            input.readBytes(txDropped);
            portStatsBuilder.setTxDropped(new BigInteger(1, txDropped));
            byte[] rxErrors = new byte[8];
            input.readBytes(rxErrors);
            portStatsBuilder.setRxErrors(new BigInteger(1, rxErrors));
            byte[] txErrors = new byte[8];
            input.readBytes(txErrors);
            portStatsBuilder.setTxErrors(new BigInteger(1, txErrors));
            byte[] rxFrameErr = new byte[8];
            input.readBytes(rxFrameErr);
            portStatsBuilder.setRxFrameErr(new BigInteger(1, rxFrameErr));
            byte[] rxOverErr = new byte[8];
            input.readBytes(rxOverErr);
            portStatsBuilder.setRxOverErr(new BigInteger(1, rxOverErr));
            byte[] rxCrcErr = new byte[8];
            input.readBytes(rxCrcErr);
            portStatsBuilder.setRxCrcErr(new BigInteger(1, rxCrcErr));
            byte[] collisions = new byte[8];
            input.readBytes(collisions);
            portStatsBuilder.setCollisions(new BigInteger(1, collisions));
            portStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            portStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            portStatsList.add(portStatsBuilder.build());
        }
        builder.setPortStats(portStatsList);
        caseBuilder.setMultipartReplyPortStats(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyQueueCase setQueue(ByteBuf input) {
        MultipartReplyQueueCaseBuilder caseBuilder = new MultipartReplyQueueCaseBuilder();
        MultipartReplyQueueBuilder builder = new MultipartReplyQueueBuilder();
        ArrayList<QueueStats> queueStatsList = new ArrayList<QueueStats>();
        while (input.readableBytes() > 0) {
            QueueStatsBuilder queueStatsBuilder = new QueueStatsBuilder();
            queueStatsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            queueStatsBuilder.setQueueId(Long.valueOf(input.readUnsignedInt()));
            byte[] txBytes = new byte[8];
            input.readBytes(txBytes);
            queueStatsBuilder.setTxBytes(new BigInteger(1, txBytes));
            byte[] txPackets = new byte[8];
            input.readBytes(txPackets);
            queueStatsBuilder.setTxPackets(new BigInteger(1, txPackets));
            byte[] txErrors = new byte[8];
            input.readBytes(txErrors);
            queueStatsBuilder.setTxErrors(new BigInteger(1, txErrors));
            queueStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            queueStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            queueStatsList.add(queueStatsBuilder.build());
        }
        builder.setQueueStats(queueStatsList);
        caseBuilder.setMultipartReplyQueue(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyGroupCase setGroup(ByteBuf input) {
        MultipartReplyGroupCaseBuilder caseBuilder = new MultipartReplyGroupCaseBuilder();
        MultipartReplyGroupBuilder builder = new MultipartReplyGroupBuilder();
        ArrayList<GroupStats> groupStatsList = new ArrayList<GroupStats>();
        while (input.readableBytes() > 0) {
            GroupStatsBuilder groupStatsBuilder = new GroupStatsBuilder();
            int bodyLength = input.readUnsignedShort();
            input.skipBytes(2);
            groupStatsBuilder.setGroupId(new GroupId(Long.valueOf(input.readUnsignedInt())));
            groupStatsBuilder.setRefCount(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] packetCount = new byte[8];
            input.readBytes(packetCount);
            groupStatsBuilder.setPacketCount(new BigInteger(1, packetCount));
            byte[] byteCount = new byte[8];
            input.readBytes(byteCount);
            groupStatsBuilder.setByteCount(new BigInteger(1, byteCount));
            groupStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            groupStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            ArrayList<BucketStats> bucketStatsList = new ArrayList<BucketStats>();
            for (int actualLength = 40; actualLength < bodyLength; actualLength += 16) {
                BucketStatsBuilder bucketStatsBuilder = new BucketStatsBuilder();
                byte[] packetCountBucket = new byte[8];
                input.readBytes(packetCountBucket);
                bucketStatsBuilder.setPacketCount(new BigInteger(1, packetCountBucket));
                byte[] byteCountBucket = new byte[8];
                input.readBytes(byteCountBucket);
                bucketStatsBuilder.setByteCount(new BigInteger(1, byteCountBucket));
                bucketStatsList.add(bucketStatsBuilder.build());
            }
            groupStatsBuilder.setBucketStats(bucketStatsList);
            groupStatsList.add(groupStatsBuilder.build());
        }
        builder.setGroupStats(groupStatsList);
        caseBuilder.setMultipartReplyGroup(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyMeterFeaturesCase setMeterFeatures(ByteBuf input) {
        MultipartReplyMeterFeaturesCaseBuilder caseBuilder = new MultipartReplyMeterFeaturesCaseBuilder();
        MultipartReplyMeterFeaturesBuilder builder = new MultipartReplyMeterFeaturesBuilder();
        builder.setMaxMeter(Long.valueOf(input.readUnsignedInt()));
        builder.setBandTypes(MultipartReplyMessageFactory.createMeterBandsBitmap(input.readUnsignedInt()));
        builder.setCapabilities(MultipartReplyMessageFactory.createMeterFlags(input.readUnsignedInt()));
        builder.setMaxBands(Short.valueOf(input.readUnsignedByte()));
        builder.setMaxColor(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(2);
        caseBuilder.setMultipartReplyMeterFeatures(builder.build());
        return caseBuilder.build();
    }

    private static MeterFlags createMeterFlags(long input) {
        Boolean mfKBPS = (input & 1L) != 0L;
        Boolean mfPKTPS = (input & 2L) != 0L;
        Boolean mfBURST = (input & 4L) != 0L;
        Boolean mfSTATS = (input & 8L) != 0L;
        return new MeterFlags(mfBURST, mfKBPS, mfPKTPS, mfSTATS);
    }

    private static MeterBandTypeBitmap createMeterBandsBitmap(long input) {
        Boolean mbtDROP = (input & 2L) != 0L;
        Boolean mbtDSCPREMARK = (input & 4L) != 0L;
        return new MeterBandTypeBitmap(mbtDROP, mbtDSCPREMARK);
    }

    private static MultipartReplyMeterCase setMeter(ByteBuf input) {
        MultipartReplyMeterCaseBuilder caseBuilder = new MultipartReplyMeterCaseBuilder();
        MultipartReplyMeterBuilder builder = new MultipartReplyMeterBuilder();
        ArrayList<MeterStats> meterStatsList = new ArrayList<MeterStats>();
        while (input.readableBytes() > 0) {
            MeterStatsBuilder meterStatsBuilder = new MeterStatsBuilder();
            meterStatsBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
            int meterStatsBodyLength = input.readUnsignedShort();
            input.skipBytes(6);
            meterStatsBuilder.setFlowCount(Long.valueOf(input.readUnsignedInt()));
            byte[] packetInCount = new byte[8];
            input.readBytes(packetInCount);
            meterStatsBuilder.setPacketInCount(new BigInteger(1, packetInCount));
            byte[] byteInCount = new byte[8];
            input.readBytes(byteInCount);
            meterStatsBuilder.setByteInCount(new BigInteger(1, byteInCount));
            meterStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            meterStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            ArrayList<MeterBandStats> meterBandStatsList = new ArrayList<MeterBandStats>();
            for (int actualLength = 40; actualLength < meterStatsBodyLength; actualLength += 16) {
                MeterBandStatsBuilder meterBandStatsBuilder = new MeterBandStatsBuilder();
                byte[] packetBandCount = new byte[8];
                input.readBytes(packetBandCount);
                meterBandStatsBuilder.setPacketBandCount(new BigInteger(1, packetBandCount));
                byte[] byteBandCount = new byte[8];
                input.readBytes(byteBandCount);
                meterBandStatsBuilder.setByteBandCount(new BigInteger(1, byteBandCount));
                meterBandStatsList.add(meterBandStatsBuilder.build());
            }
            meterStatsBuilder.setMeterBandStats(meterBandStatsList);
            meterStatsList.add(meterStatsBuilder.build());
        }
        builder.setMeterStats(meterStatsList);
        caseBuilder.setMultipartReplyMeter(builder.build());
        return caseBuilder.build();
    }

    private MultipartReplyMeterConfigCase setMeterConfig(ByteBuf input) {
        MultipartReplyMeterConfigCaseBuilder caseBuilder = new MultipartReplyMeterConfigCaseBuilder();
        MultipartReplyMeterConfigBuilder builder = new MultipartReplyMeterConfigBuilder();
        ArrayList<MeterConfig> meterConfigList = new ArrayList<MeterConfig>();
        while (input.readableBytes() > 0) {
            MeterConfigBuilder meterConfigBuilder = new MeterConfigBuilder();
            int meterConfigBodyLength = input.readUnsignedShort();
            meterConfigBuilder.setFlags(MultipartReplyMessageFactory.createMeterFlags(input.readUnsignedShort()));
            meterConfigBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
            int actualLength = 8;
            ArrayList<Bands> bandsList = new ArrayList<Bands>();
            while (actualLength < meterConfigBodyLength) {
                int bandStartIndex = input.readerIndex();
                BandsBuilder bandsBuilder = new BandsBuilder();
                int bandType = input.readUnsignedShort();
                switch (bandType) {
                    case 1: {
                        MeterBandDropCaseBuilder bandDropCaseBuilder = new MeterBandDropCaseBuilder();
                        MeterBandDropBuilder bandDropBuilder = new MeterBandDropBuilder();
                        bandDropBuilder.setType(MeterBandType.forValue((int)bandType));
                        actualLength += input.readUnsignedShort();
                        bandDropBuilder.setRate(Long.valueOf(input.readUnsignedInt()));
                        bandDropBuilder.setBurstSize(Long.valueOf(input.readUnsignedInt()));
                        input.skipBytes(4);
                        bandDropCaseBuilder.setMeterBandDrop(bandDropBuilder.build());
                        bandsBuilder.setMeterBand((MeterBand)bandDropCaseBuilder.build());
                        break;
                    }
                    case 2: {
                        MeterBandDscpRemarkCaseBuilder bandDscpRemarkCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
                        MeterBandDscpRemarkBuilder bandDscpRemarkBuilder = new MeterBandDscpRemarkBuilder();
                        bandDscpRemarkBuilder.setType(MeterBandType.forValue((int)bandType));
                        actualLength += input.readUnsignedShort();
                        bandDscpRemarkBuilder.setRate(Long.valueOf(input.readUnsignedInt()));
                        bandDscpRemarkBuilder.setBurstSize(Long.valueOf(input.readUnsignedInt()));
                        bandDscpRemarkBuilder.setPrecLevel(Short.valueOf(input.readUnsignedByte()));
                        input.skipBytes(3);
                        bandDscpRemarkCaseBuilder.setMeterBandDscpRemark(bandDscpRemarkBuilder.build());
                        bandsBuilder.setMeterBand((MeterBand)bandDscpRemarkCaseBuilder.build());
                        break;
                    }
                    case 65535: {
                        actualLength += input.readUnsignedShort();
                        long expId = input.getUnsignedInt(input.readerIndex() + 8);
                        input.readerIndex(bandStartIndex);
                        OFDeserializer deserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createMeterBandDeserializerKey((short)4, (Long)expId));
                        bandsBuilder.setMeterBand((MeterBand)deserializer.deserialize(input));
                        break;
                    }
                }
                bandsList.add(bandsBuilder.build());
            }
            meterConfigBuilder.setBands(bandsList);
            meterConfigList.add(meterConfigBuilder.build());
        }
        builder.setMeterConfig(meterConfigList);
        caseBuilder.setMultipartReplyMeterConfig(builder.build());
        return caseBuilder.build();
    }

    private MultipartReplyExperimenterCase setExperimenter(ByteBuf input) {
        long expId = input.readUnsignedInt();
        long expType = input.readUnsignedInt();
        OFDeserializer deserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createMultipartReplyMessageDeserializerKey((short)4, (long)expId, (long)expType));
        MultipartReplyExperimenterBuilder mpExperimenterBld = new MultipartReplyExperimenterBuilder().setExperimenter(new ExperimenterId(Long.valueOf(expId))).setExpType(Long.valueOf(expType)).setExperimenterDataOfChoice((ExperimenterDataOfChoice)deserializer.deserialize(input));
        MultipartReplyExperimenterCaseBuilder mpReplyExperimenterCaseBld = new MultipartReplyExperimenterCaseBuilder().setMultipartReplyExperimenter(mpExperimenterBld.build());
        return mpReplyExperimenterCaseBld.build();
    }

    private static MultipartReplyPortDescCase setPortDesc(ByteBuf input) {
        MultipartReplyPortDescCaseBuilder caseBuilder = new MultipartReplyPortDescCaseBuilder();
        MultipartReplyPortDescBuilder builder = new MultipartReplyPortDescBuilder();
        ArrayList<Ports> portsList = new ArrayList<Ports>();
        while (input.readableBytes() > 0) {
            PortsBuilder portsBuilder = new PortsBuilder();
            portsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] hwAddress = new byte[6];
            input.readBytes(hwAddress);
            portsBuilder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString((byte[])hwAddress)));
            input.skipBytes(2);
            portsBuilder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)input, (int)16));
            portsBuilder.setConfig(MultipartReplyMessageFactory.createPortConfig(input.readUnsignedInt()));
            portsBuilder.setState(MultipartReplyMessageFactory.createPortState(input.readUnsignedInt()));
            portsBuilder.setCurrentFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setAdvertisedFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setSupportedFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setPeerFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setCurrSpeed(Long.valueOf(input.readUnsignedInt()));
            portsBuilder.setMaxSpeed(Long.valueOf(input.readUnsignedInt()));
            portsList.add(portsBuilder.build());
        }
        builder.setPorts(portsList);
        caseBuilder.setMultipartReplyPortDesc(builder.build());
        return caseBuilder.build();
    }

    private static PortConfig createPortConfig(long input) {
        Boolean pcPortDown = (input & 1L) != 0L;
        Boolean pcNRecv = (input & 4L) != 0L;
        Boolean pcNFwd = (input & 0x20L) != 0L;
        Boolean pcNPacketIn = (input & 0x40L) != 0L;
        return new PortConfig(pcNFwd, pcNPacketIn, pcNRecv, pcPortDown);
    }

    private static PortState createPortState(long input) {
        Boolean psLinkDown = (input & 1L) != 0L;
        Boolean psBlocked = (input & 2L) != 0L;
        Boolean psLive = (input & 4L) != 0L;
        return new PortState(psBlocked, psLinkDown, psLive);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean pf10mbHd = (input & 1L) != 0L;
        Boolean pf10mbFd = (input & 2L) != 0L;
        Boolean pf100mbHd = (input & 4L) != 0L;
        Boolean pf100mbFd = (input & 8L) != 0L;
        Boolean pf1gbHd = (input & 0x10L) != 0L;
        Boolean pf1gbFd = (input & 0x20L) != 0L;
        Boolean pf10gbFd = (input & 0x40L) != 0L;
        Boolean pf40gbFd = (input & 0x80L) != 0L;
        Boolean pf100gbFd = (input & 0x100L) != 0L;
        Boolean pf1tbFd = (input & 0x200L) != 0L;
        Boolean pfOther = (input & 0x400L) != 0L;
        Boolean pfCopper = (input & 0x800L) != 0L;
        Boolean pfFiber = (input & 0x1000L) != 0L;
        Boolean pfAutoneg = (input & 0x2000L) != 0L;
        Boolean pfPause = (input & 0x4000L) != 0L;
        Boolean pfPauseAsym = (input & 0x8000L) != 0L;
        return new PortFeatures(pf100gbFd, pf100mbFd, pf100mbHd, pf10gbFd, pf10mbFd, pf10mbHd, pf1gbFd, pf1gbHd, pf1tbFd, pf40gbFd, pfAutoneg, pfCopper, pfFiber, pfOther, pfPause, pfPauseAsym);
    }

    private static MultipartReplyGroupFeaturesCase setGroupFeatures(ByteBuf rawMessage) {
        MultipartReplyGroupFeaturesCaseBuilder caseBuilder = new MultipartReplyGroupFeaturesCaseBuilder();
        MultipartReplyGroupFeaturesBuilder featuresBuilder = new MultipartReplyGroupFeaturesBuilder();
        featuresBuilder.setTypes(MultipartReplyMessageFactory.createGroupType(rawMessage.readUnsignedInt()));
        featuresBuilder.setCapabilities(MultipartReplyMessageFactory.createCapabilities(rawMessage.readUnsignedInt()));
        ArrayList<Long> maxGroupsList = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            maxGroupsList.add(rawMessage.readUnsignedInt());
        }
        featuresBuilder.setMaxGroups(maxGroupsList);
        ArrayList<ActionType> actionBitmaps = new ArrayList<ActionType>();
        for (int i = 0; i < 4; ++i) {
            actionBitmaps.add(MultipartReplyMessageFactory.createActionBitmap(rawMessage.readUnsignedInt()));
        }
        featuresBuilder.setActionsBitmap(actionBitmaps);
        caseBuilder.setMultipartReplyGroupFeatures(featuresBuilder.build());
        return caseBuilder.build();
    }

    private static ActionType createActionBitmap(long input) {
        Boolean atOutput = (input & 1L) != 0L;
        Boolean atCopyTTLout = (input & 0x800L) != 0L;
        Boolean atCopyTTLin = (input & 0x1000L) != 0L;
        Boolean atSetMplsTTL = (input & 0x8000L) != 0L;
        Boolean atDecMplsTTL = (input & 0x10000L) != 0L;
        Boolean atPushVLAN = (input & 0x20000L) != 0L;
        Boolean atPopVLAN = (input & 0x40000L) != 0L;
        Boolean atPushMPLS = (input & 0x80000L) != 0L;
        Boolean atPopMPLS = (input & 0x100000L) != 0L;
        Boolean atSetQueue = (input & 0x200000L) != 0L;
        Boolean atGroup = (input & 0x400000L) != 0L;
        Boolean atSetNWTTL = (input & 0x800000L) != 0L;
        Boolean atDecNWTTL = (input & 0x1000000L) != 0L;
        Boolean atSetField = (input & 0x2000000L) != 0L;
        Boolean atPushPBB = (input & 0x4000000L) != 0L;
        Boolean atPopPBB = (input & 0x8000000L) != 0L;
        Boolean atExperimenter = false;
        return new ActionType(atCopyTTLin, atCopyTTLout, atDecMplsTTL, atDecNWTTL, atExperimenter, atGroup, atOutput, atPopMPLS, atPopPBB, atPopVLAN, atPushMPLS, atPushPBB, atPushVLAN, atSetField, atSetMplsTTL, atSetNWTTL, atSetQueue);
    }

    private static GroupCapabilities createCapabilities(long input) {
        Boolean gcSelectWeight = (input & 1L) != 0L;
        Boolean gcSelectLiveness = (input & 2L) != 0L;
        Boolean gcChaining = (input & 4L) != 0L;
        Boolean gcChainingChecks = (input & 8L) != 0L;
        return new GroupCapabilities(gcChaining, gcChainingChecks, gcSelectLiveness, gcSelectWeight);
    }

    private static GroupTypes createGroupType(long input) {
        Boolean gtAll = (input & 1L) != 0L;
        Boolean gtSelect = (input & 2L) != 0L;
        Boolean gtIndirect = (input & 4L) != 0L;
        Boolean gtFF = (input & 8L) != 0L;
        return new GroupTypes(gtAll, gtFF, gtIndirect, gtSelect);
    }

    private MultipartReplyGroupDescCase setGroupDesc(ByteBuf input) {
        MultipartReplyGroupDescCaseBuilder caseBuilder = new MultipartReplyGroupDescCaseBuilder();
        MultipartReplyGroupDescBuilder builder = new MultipartReplyGroupDescBuilder();
        ArrayList<GroupDesc> groupDescsList = new ArrayList<GroupDesc>();
        while (input.readableBytes() > 0) {
            int bucketsLength;
            GroupDescBuilder groupDescBuilder = new GroupDescBuilder();
            int bodyLength = input.readUnsignedShort();
            groupDescBuilder.setType(GroupType.forValue((int)input.readUnsignedByte()));
            input.skipBytes(1);
            groupDescBuilder.setGroupId(new GroupId(Long.valueOf(input.readUnsignedInt())));
            ArrayList<BucketsList> bucketsList = new ArrayList<BucketsList>();
            for (int actualLength = 8; actualLength < bodyLength; actualLength += bucketsLength) {
                BucketsListBuilder bucketsBuilder = new BucketsListBuilder();
                bucketsLength = input.readUnsignedShort();
                bucketsBuilder.setWeight(Integer.valueOf(input.readUnsignedShort()));
                bucketsBuilder.setWatchPort(new PortNumber(Long.valueOf(input.readUnsignedInt())));
                bucketsBuilder.setWatchGroup(Long.valueOf(input.readUnsignedInt()));
                input.skipBytes(4);
                CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
                List actions = ListDeserializer.deserializeList((short)4, bucketsLength - 16, input, keyMaker, this.registry);
                bucketsBuilder.setAction(actions);
                bucketsList.add(bucketsBuilder.build());
            }
            groupDescBuilder.setBucketsList(bucketsList);
            groupDescsList.add(groupDescBuilder.build());
        }
        builder.setGroupDesc(groupDescsList);
        caseBuilder.setMultipartReplyGroupDesc(builder.build());
        return caseBuilder.build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

