/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterDeserializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIdsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.desc._case.MultipartRequestDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group.desc._case.MultipartRequestGroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group.features._case.MultipartRequestGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter._case.MultipartRequestMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.config._case.MultipartRequestMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.features._case.MultipartRequestMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.desc._case.MultipartRequestPortDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table._case.MultipartRequestTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.MultipartRequestTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeaturePropertiesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultipartRequestInputMessageFactory
implements OFDeserializer<MultipartRequestInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;
    private static final byte PADDING = 4;
    private static final byte FLOW_PADDING_1 = 3;
    private static final byte FLOW_PADDING_2 = 4;
    private static final byte AGGREGATE_PADDING_1 = 3;
    private static final byte AGGREGATE_PADDING_2 = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_TABLE_FEATURES = 5;
    private static final byte MAX_TABLE_NAME_LENGTH = 32;
    private static final byte MULTIPART_REQUEST_TABLE_FEATURES_STRUCTURE_LENGTH = 64;
    private static final byte COMMON_PROPERTY_LENGTH = 4;

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }

    public MultipartRequestInput deserialize(ByteBuf rawMessage) {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        builder.setType(MultipartRequestInputMessageFactory.getMultipartType(type));
        builder.setFlags(MultipartRequestInputMessageFactory.getMultipartRequestFlags(rawMessage.readUnsignedShort()));
        rawMessage.skipBytes(4);
        switch (MultipartType.forValue((int)type)) {
            case OFPMPDESC: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setDesc(rawMessage));
                break;
            }
            case OFPMPFLOW: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setFlow(rawMessage));
                break;
            }
            case OFPMPAGGREGATE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setAggregate(rawMessage));
                break;
            }
            case OFPMPTABLE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setTable(rawMessage));
                break;
            }
            case OFPMPTABLEFEATURES: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setTableFeatures(rawMessage));
                break;
            }
            case OFPMPPORTSTATS: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setPortStats(rawMessage));
                break;
            }
            case OFPMPPORTDESC: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setPortDesc(rawMessage));
                break;
            }
            case OFPMPQUEUE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setQueue(rawMessage));
                break;
            }
            case OFPMPGROUP: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setGroup(rawMessage));
                break;
            }
            case OFPMPGROUPDESC: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setGroupDesc(rawMessage));
                break;
            }
            case OFPMPGROUPFEATURES: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setGroupFeatures(rawMessage));
                break;
            }
            case OFPMPMETER: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setMeter(rawMessage));
                break;
            }
            case OFPMPMETERCONFIG: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setMeterConfig(rawMessage));
                break;
            }
            case OFPMPMETERFEATURES: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setMeterFeatures(rawMessage));
                break;
            }
            case OFPMPEXPERIMENTER: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setExperimenter(rawMessage));
                break;
            }
        }
        return builder.build();
    }

    private static MultipartType getMultipartType(int input) {
        return MultipartType.forValue((int)input);
    }

    private static MultipartRequestFlags getMultipartRequestFlags(int input) {
        Boolean _oFPMPFREQMORE = (input & 1) > 0;
        MultipartRequestFlags flag = new MultipartRequestFlags(_oFPMPFREQMORE);
        return flag;
    }

    private MultipartRequestTableFeaturesCase setTableFeatures(ByteBuf input) {
        MultipartRequestTableFeaturesCaseBuilder caseBuilder = new MultipartRequestTableFeaturesCaseBuilder();
        MultipartRequestTableFeaturesBuilder tableFeaturesBuilder = new MultipartRequestTableFeaturesBuilder();
        ArrayList<TableFeatures> features = new ArrayList<TableFeatures>();
        while (input.readableBytes() > 0) {
            TableFeaturesBuilder featuresBuilder = new TableFeaturesBuilder();
            int length = input.readUnsignedShort();
            featuresBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
            input.skipBytes(5);
            featuresBuilder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)input, (int)32));
            byte[] metadataMatch = new byte[8];
            input.readBytes(metadataMatch);
            featuresBuilder.setMetadataMatch(new BigInteger(1, metadataMatch));
            byte[] metadataWrite = new byte[8];
            input.readBytes(metadataWrite);
            featuresBuilder.setMetadataWrite(new BigInteger(1, metadataWrite));
            featuresBuilder.setConfig(MultipartRequestInputMessageFactory.createTableConfig(input.readUnsignedInt()));
            featuresBuilder.setMaxEntries(Long.valueOf(input.readUnsignedInt()));
            featuresBuilder.setTableFeatureProperties(this.createTableFeaturesProperties(input, length - 64));
            features.add(featuresBuilder.build());
        }
        tableFeaturesBuilder.setTableFeatures(features);
        caseBuilder.setMultipartRequestTableFeatures(tableFeaturesBuilder.build());
        return caseBuilder.build();
    }

    private List<TableFeatureProperties> createTableFeaturesProperties(ByteBuf input, int length) {
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        int tableFeaturesLength = length;
        while (tableFeaturesLength > 0) {
            CodeKeyMaker keyMaker;
            int propStartIndex = input.readerIndex();
            TableFeaturePropertiesBuilder builder = new TableFeaturePropertiesBuilder();
            TableFeaturesPropType type = TableFeaturesPropType.forValue((int)input.readUnsignedShort());
            builder.setType(type);
            int propertyLength = input.readUnsignedShort();
            int paddingRemainder = propertyLength % 8;
            tableFeaturesLength -= propertyLength;
            if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS)) {
                InstructionRelatedTableFeaturePropertyBuilder insBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
                List instructions = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                insBuilder.setInstruction(instructions);
                builder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLES) || type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS)) {
                propertyLength -= 4;
                NextTableRelatedTableFeaturePropertyBuilder tableBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
                ArrayList<NextTableIds> ids = new ArrayList<NextTableIds>();
                while (propertyLength > 0) {
                    NextTableIdsBuilder nextTableIdsBuilder = new NextTableIdsBuilder();
                    nextTableIdsBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
                    ids.add(nextTableIdsBuilder.build());
                    --propertyLength;
                }
                tableBuilder.setNextTableIds(ids);
                builder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)tableBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS)) {
                ActionRelatedTableFeaturePropertyBuilder actionBuilder = new ActionRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
                List actions = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                actionBuilder.setAction(actions);
                builder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actionBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTMATCH) || type.equals((Object)TableFeaturesPropType.OFPTFPTWILDCARDS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS)) {
                OxmRelatedTableFeaturePropertyBuilder oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
                keyMaker = CodeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
                List entries = ListDeserializer.deserializeHeaders((short)4, propertyLength - 4, input, keyMaker, this.registry);
                oxmBuilder.setMatchEntry(entries);
                builder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTER) || type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS)) {
                long expId = input.readUnsignedInt();
                input.readerIndex(propStartIndex);
                OFDeserializer propDeserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createMultipartReplyTFDeserializerKey((short)4, (Long)expId));
                TableFeatureProperties expProp = (TableFeatureProperties)propDeserializer.deserialize(input);
                properties.add(expProp);
                continue;
            }
            if (paddingRemainder != 0) {
                input.skipBytes(8 - paddingRemainder);
                tableFeaturesLength -= 8 - paddingRemainder;
            }
            properties.add(builder.build());
        }
        return properties;
    }

    private static TableConfig createTableConfig(long input) {
        boolean deprecated = (input & 3L) != 0L;
        return new TableConfig(Boolean.valueOf(deprecated));
    }

    private MultipartRequestDescCase setDesc(ByteBuf input) {
        MultipartRequestDescCaseBuilder caseBuilder = new MultipartRequestDescCaseBuilder();
        MultipartRequestDescBuilder descBuilder = new MultipartRequestDescBuilder();
        descBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestDesc(descBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestFlowCase setFlow(ByteBuf input) {
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder flowBuilder = new MultipartRequestFlowBuilder();
        flowBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(3);
        flowBuilder.setOutPort(Long.valueOf(input.readUnsignedInt()));
        flowBuilder.setOutGroup(Long.valueOf(input.readUnsignedInt()));
        input.skipBytes(4);
        byte[] cookie = new byte[8];
        input.readBytes(cookie);
        flowBuilder.setCookie(new BigInteger(1, cookie));
        byte[] cookie_mask = new byte[8];
        input.readBytes(cookie_mask);
        flowBuilder.setCookieMask(new BigInteger(1, cookie_mask));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
        flowBuilder.setMatch((Match)matchDeserializer.deserialize(input));
        caseBuilder.setMultipartRequestFlow(flowBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestAggregateCase setAggregate(ByteBuf input) {
        MultipartRequestAggregateCaseBuilder caseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder aggregateBuilder = new MultipartRequestAggregateBuilder();
        aggregateBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(3);
        aggregateBuilder.setOutPort(Long.valueOf(input.readUnsignedInt()));
        aggregateBuilder.setOutGroup(Long.valueOf(input.readUnsignedInt()));
        input.skipBytes(4);
        byte[] cookie = new byte[8];
        input.readBytes(cookie);
        aggregateBuilder.setCookie(new BigInteger(1, cookie));
        byte[] cookie_mask = new byte[8];
        input.readBytes(cookie_mask);
        aggregateBuilder.setCookieMask(new BigInteger(1, cookie_mask));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
        aggregateBuilder.setMatch((Match)matchDeserializer.deserialize(input));
        caseBuilder.setMultipartRequestAggregate(aggregateBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestPortDescCase setPortDesc(ByteBuf input) {
        MultipartRequestPortDescCaseBuilder caseBuilder = new MultipartRequestPortDescCaseBuilder();
        MultipartRequestPortDescBuilder portBuilder = new MultipartRequestPortDescBuilder();
        portBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestPortDesc(portBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestPortStatsCase setPortStats(ByteBuf input) {
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder portBuilder = new MultipartRequestPortStatsBuilder();
        portBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
        caseBuilder.setMultipartRequestPortStats(portBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestQueueCase setQueue(ByteBuf input) {
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder queueBuilder = new MultipartRequestQueueBuilder();
        queueBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
        queueBuilder.setQueueId(Long.valueOf(input.readUnsignedInt()));
        caseBuilder.setMultipartRequestQueue(queueBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestGroupCase setGroup(ByteBuf input) {
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder groupBuilder = new MultipartRequestGroupBuilder();
        groupBuilder.setGroupId(new GroupId(Long.valueOf(input.readUnsignedInt())));
        caseBuilder.setMultipartRequestGroup(groupBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestGroupDescCase setGroupDesc(ByteBuf input) {
        MultipartRequestGroupDescCaseBuilder caseBuilder = new MultipartRequestGroupDescCaseBuilder();
        MultipartRequestGroupDescBuilder groupBuilder = new MultipartRequestGroupDescBuilder();
        groupBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestGroupDesc(groupBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestGroupFeaturesCase setGroupFeatures(ByteBuf input) {
        MultipartRequestGroupFeaturesCaseBuilder caseBuilder = new MultipartRequestGroupFeaturesCaseBuilder();
        MultipartRequestGroupFeaturesBuilder groupBuilder = new MultipartRequestGroupFeaturesBuilder();
        groupBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestGroupFeatures(groupBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestMeterCase setMeter(ByteBuf input) {
        MultipartRequestMeterCaseBuilder caseBuilder = new MultipartRequestMeterCaseBuilder();
        MultipartRequestMeterBuilder meterBuilder = new MultipartRequestMeterBuilder();
        meterBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
        caseBuilder.setMultipartRequestMeter(meterBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestMeterConfigCase setMeterConfig(ByteBuf input) {
        MultipartRequestMeterConfigCaseBuilder caseBuilder = new MultipartRequestMeterConfigCaseBuilder();
        MultipartRequestMeterConfigBuilder meterBuilder = new MultipartRequestMeterConfigBuilder();
        meterBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
        caseBuilder.setMultipartRequestMeterConfig(meterBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestMeterFeaturesCase setMeterFeatures(ByteBuf input) {
        MultipartRequestMeterFeaturesCaseBuilder caseBuilder = new MultipartRequestMeterFeaturesCaseBuilder();
        MultipartRequestMeterFeaturesBuilder meterBuilder = new MultipartRequestMeterFeaturesBuilder();
        meterBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestMeterFeatures(meterBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestTableCase setTable(ByteBuf input) {
        MultipartRequestTableCaseBuilder caseBuilder = new MultipartRequestTableCaseBuilder();
        MultipartRequestTableBuilder tableBuilder = new MultipartRequestTableBuilder();
        tableBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestTable(tableBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestExperimenterCase setExperimenter(ByteBuf input) {
        MultipartRequestExperimenterCaseBuilder caseBuilder = new MultipartRequestExperimenterCaseBuilder();
        MultipartRequestExperimenterBuilder experimenterBuilder = new MultipartRequestExperimenterBuilder();
        caseBuilder.setMultipartRequestExperimenter(experimenterBuilder.build());
        return caseBuilder.build();
    }
}

