/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.OpenflowUtils;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPortBuilder;

public class OF10FeaturesReplyMessageFactory
implements OFDeserializer<GetFeaturesOutput> {
    private static final byte PADDING_IN_FEATURES_REPLY_HEADER = 3;

    public GetFeaturesOutput deserialize(ByteBuf rawMessage) {
        GetFeaturesOutputBuilder builder = new GetFeaturesOutputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] datapathId = new byte[8];
        rawMessage.readBytes(datapathId);
        builder.setDatapathId(new BigInteger(1, datapathId));
        builder.setBuffers(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTables(Short.valueOf(rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(3);
        builder.setCapabilitiesV10(OF10FeaturesReplyMessageFactory.createCapabilitiesV10(rawMessage.readUnsignedInt()));
        builder.setActionsV10(OF10FeaturesReplyMessageFactory.createActionsV10(rawMessage.readUnsignedInt()));
        ArrayList<PhyPort> ports = new ArrayList<PhyPort>();
        while (rawMessage.readableBytes() > 0) {
            ports.add(OF10FeaturesReplyMessageFactory.deserializePort(rawMessage));
        }
        builder.setPhyPort(ports);
        return builder.build();
    }

    private static CapabilitiesV10 createCapabilitiesV10(long input) {
        Boolean flowStats = (input & 1L) != 0L;
        Boolean tableStats = (input & 2L) != 0L;
        Boolean portStats = (input & 4L) != 0L;
        Boolean stp = (input & 8L) != 0L;
        Boolean reserved = (input & 0x10L) != 0L;
        Boolean ipReasm = (input & 0x20L) != 0L;
        Boolean queueStats = (input & 0x40L) != 0L;
        Boolean arpMatchIp = (input & 0x80L) != 0L;
        return new CapabilitiesV10(arpMatchIp, flowStats, ipReasm, portStats, queueStats, reserved, stp, tableStats);
    }

    private static ActionTypeV10 createActionsV10(long input) {
        Boolean output = (input & 1L) != 0L;
        Boolean setVLANvid = (input & 2L) != 0L;
        Boolean setVLANpcp = (input & 4L) != 0L;
        Boolean stripVLAN = (input & 8L) != 0L;
        Boolean setDLsrc = (input & 0x10L) != 0L;
        Boolean setDLdst = (input & 0x20L) != 0L;
        Boolean setNWsrc = (input & 0x40L) != 0L;
        Boolean setNWdst = (input & 0x80L) != 0L;
        Boolean setNWtos = (input & 0x100L) != 0L;
        Boolean setTPsrc = (input & 0x200L) != 0L;
        Boolean setTPdst = (input & 0x400L) != 0L;
        Boolean enqueue = (input & 0x800L) != 0L;
        Boolean vendor = (input & 0x1000L) != 0L;
        return new ActionTypeV10(enqueue, output, setDLdst, setDLsrc, setNWdst, setNWsrc, setNWtos, setTPdst, setTPsrc, setVLANpcp, setVLANvid, stripVLAN, vendor);
    }

    private static PhyPort deserializePort(ByteBuf rawMessage) {
        PhyPortBuilder builder = new PhyPortBuilder();
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedShort()));
        byte[] address = new byte[6];
        rawMessage.readBytes(address);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString((byte[])address)));
        builder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)rawMessage, (int)16));
        builder.setConfigV10(OpenflowUtils.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setStateV10(OpenflowUtils.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        return builder.build();
    }
}

