/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;

public class OF10FlowModInputMessageFactory
implements OFDeserializer<FlowModInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }

    public FlowModInput deserialize(ByteBuf rawMessage) {
        FlowModInputBuilder builder = new FlowModInputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(1, 0, MatchV10.class));
        builder.setMatchV10((MatchV10)matchDeserializer.deserialize(rawMessage));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setCommand(FlowModCommand.forValue((int)rawMessage.readUnsignedShort()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setHardTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setOutPort(new PortNumber(Long.valueOf(rawMessage.readUnsignedShort())));
        builder.setFlagsV10(OF10FlowModInputMessageFactory.createFlowModFlagsFromBitmap(rawMessage.readUnsignedShort()));
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)1);
        List actions = ListDeserializer.deserializeList((short)1, rawMessage.readableBytes(), rawMessage, keyMaker, this.registry);
        builder.setAction(actions);
        return builder.build();
    }

    private static FlowModFlagsV10 createFlowModFlagsFromBitmap(int input) {
        Boolean _oFPFFSENDFLOWREM = (input & 1) > 0;
        Boolean _oFPFFCHECKOVERLAP = (input & 2) > 0;
        Boolean _oFPFFEMERG = (input & 4) > 0;
        return new FlowModFlagsV10(_oFPFFCHECKOVERLAP, _oFPFFEMERG, _oFPFFSENDFLOWREM);
    }
}

