/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;

public class OF10FlowRemovedMessageFactory
implements OFDeserializer<FlowRemovedMessage>,
DeserializerRegistryInjector {
    private static final byte PADDING_IN_FLOW_REMOVED_MESSAGE = 1;
    private static final byte PADDING_IN_FLOW_REMOVED_MESSAGE_2 = 2;
    private DeserializerRegistry registry;

    public FlowRemovedMessage deserialize(ByteBuf rawMessage) {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(1, 0, MatchV10.class));
        builder.setMatchV10((MatchV10)matchDeserializer.deserialize(rawMessage));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(FlowRemovedReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        builder.setDurationSec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setDurationNsec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        rawMessage.skipBytes(2);
        byte[] packetCount = new byte[8];
        rawMessage.readBytes(packetCount);
        builder.setPacketCount(new BigInteger(1, packetCount));
        byte[] byteCount = new byte[8];
        rawMessage.readBytes(byteCount);
        builder.setByteCount(new BigInteger(1, byteCount));
        return builder.build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

