/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;

public class OF10PacketInMessageFactory
implements OFDeserializer<PacketInMessage> {
    private static final byte PADDING_IN_PACKET_IN_HEADER = 1;

    public PacketInMessage deserialize(ByteBuf rawMessage) {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTotalLen(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setInPort(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(PacketInReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        int remainingBytes = rawMessage.readableBytes();
        if (remainingBytes > 0) {
            byte[] buf = new byte[remainingBytes];
            rawMessage.readBytes(buf);
            builder.setData(buf);
        }
        return builder.build();
    }
}

