/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInputBuilder;

public class OF10PacketOutInputMessageFactory
implements OFDeserializer<PacketOutInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }

    public PacketOutInput deserialize(ByteBuf rawMessage) {
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setInPort(new PortNumber(Long.valueOf(rawMessage.readUnsignedShort())));
        short actions_len = rawMessage.readShort();
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)1);
        List actions = ListDeserializer.deserializeList((short)1, actions_len, rawMessage, keyMaker, this.registry);
        builder.setAction(actions);
        byte[] data = rawMessage.readBytes(rawMessage.readableBytes()).array();
        if (data != null) {
            builder.setData(data);
        }
        return builder.build();
    }
}

