/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;

public class OF10PortModInputMessageFactory
implements OFDeserializer<PortModInput> {
    public PortModInput deserialize(ByteBuf rawMessage) {
        PortModInputBuilder builder = new PortModInputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setPortNo(new PortNumber(Long.valueOf(rawMessage.readUnsignedShort())));
        byte[] hwAddress = new byte[6];
        rawMessage.readBytes(hwAddress);
        builder.setHwAddress(new MacAddress(ByteBufUtils.macAddressToString((byte[])hwAddress)));
        builder.setConfigV10(OF10PortModInputMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setMaskV10(OF10PortModInputMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setAdvertiseV10(OF10PortModInputMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static PortConfigV10 createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noStp = (input & 2L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noRecvStp = (input & 8L) > 0L;
        Boolean _noFlood = (input & 0x10L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfigV10(_noFlood, _noFwd, _noPacketIn, _noRecv, _noRecvStp, _noStp, _portDown);
    }

    private static PortFeaturesV10 createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _copper = (input & 0x80L) > 0L;
        Boolean _fiber = (input & 0x100L) > 0L;
        Boolean _autoneg = (input & 0x200L) > 0L;
        Boolean _pause = (input & 0x400L) > 0L;
        Boolean _pauseAsym = (input & 0x800L) > 0L;
        return new PortFeaturesV10(_100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _autoneg, _copper, _fiber, _pause, _pauseAsym);
    }
}

