/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.OpenflowUtils;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;

public class OF10PortStatusMessageFactory
implements OFDeserializer<PortStatusMessage> {
    private static final byte PADDING_IN_PORT_STATUS_HEADER = 7;

    public PortStatusMessage deserialize(ByteBuf rawMessage) {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setReason(PortReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(7);
        OF10PortStatusMessageFactory.deserializePort(rawMessage, builder);
        return builder.build();
    }

    private static void deserializePort(ByteBuf rawMessage, PortStatusMessageBuilder builder) {
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedShort()));
        byte[] address = new byte[6];
        rawMessage.readBytes(address);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString((byte[])address)));
        builder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)rawMessage, (int)16));
        builder.setConfigV10(OpenflowUtils.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setStateV10(OpenflowUtils.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeaturesV10(OpenflowUtils.createPortFeatures(rawMessage.readUnsignedInt()));
    }
}

