/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.desc._case.MultipartRequestDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table._case.MultipartRequestTableBuilder;

public class OF10StatsRequestInputFactory
implements OFDeserializer<MultipartRequestInput>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;
    private static final byte FLOW_PADDING_1 = 1;
    private static final byte AGGREGATE_PADDING_1 = 1;

    public MultipartRequestInput deserialize(ByteBuf rawMessage) {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        builder.setType(OF10StatsRequestInputFactory.getMultipartType(type));
        builder.setFlags(OF10StatsRequestInputFactory.getMultipartRequestFlags(rawMessage.readUnsignedShort()));
        switch (OF10StatsRequestInputFactory.getMultipartType(type)) {
            case OFPMPDESC: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setDesc(rawMessage));
                break;
            }
            case OFPMPFLOW: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setFlow(rawMessage));
                break;
            }
            case OFPMPAGGREGATE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setAggregate(rawMessage));
                break;
            }
            case OFPMPTABLE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setTable(rawMessage));
                break;
            }
            case OFPMPPORTSTATS: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setPortStats(rawMessage));
                break;
            }
            case OFPMPQUEUE: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setQueue(rawMessage));
                break;
            }
            case OFPMPEXPERIMENTER: {
                builder.setMultipartRequestBody((MultipartRequestBody)this.setExperimenter(rawMessage));
                break;
            }
        }
        return builder.build();
    }

    private MultipartRequestExperimenterCase setExperimenter(ByteBuf input) {
        MultipartRequestExperimenterCaseBuilder caseBuilder = new MultipartRequestExperimenterCaseBuilder();
        MultipartRequestExperimenterBuilder experimenterBuilder = new MultipartRequestExperimenterBuilder();
        caseBuilder.setMultipartRequestExperimenter(experimenterBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestQueueCase setQueue(ByteBuf input) {
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder queueBuilder = new MultipartRequestQueueBuilder();
        queueBuilder.setPortNo(Long.valueOf(input.readUnsignedShort()));
        input.skipBytes(2);
        queueBuilder.setQueueId(Long.valueOf(input.readUnsignedInt()));
        caseBuilder.setMultipartRequestQueue(queueBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestPortStatsCase setPortStats(ByteBuf input) {
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder portBuilder = new MultipartRequestPortStatsBuilder();
        portBuilder.setPortNo(Long.valueOf(input.readUnsignedShort()));
        caseBuilder.setMultipartRequestPortStats(portBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestTableCase setTable(ByteBuf input) {
        MultipartRequestTableCaseBuilder caseBuilder = new MultipartRequestTableCaseBuilder();
        MultipartRequestTableBuilder tableBuilder = new MultipartRequestTableBuilder();
        tableBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestTable(tableBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestAggregateCase setAggregate(ByteBuf input) {
        MultipartRequestAggregateCaseBuilder caseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder aggregateBuilder = new MultipartRequestAggregateBuilder();
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(1, 0, MatchV10.class));
        aggregateBuilder.setMatchV10((MatchV10)matchDeserializer.deserialize(input));
        aggregateBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(1);
        aggregateBuilder.setOutPort(Long.valueOf(input.readUnsignedShort()));
        caseBuilder.setMultipartRequestAggregate(aggregateBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestFlowCase setFlow(ByteBuf input) {
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder flowBuilder = new MultipartRequestFlowBuilder();
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(1, 0, MatchV10.class));
        flowBuilder.setMatchV10((MatchV10)matchDeserializer.deserialize(input));
        flowBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(1);
        flowBuilder.setOutPort(Long.valueOf(input.readUnsignedShort()));
        caseBuilder.setMultipartRequestFlow(flowBuilder.build());
        return caseBuilder.build();
    }

    private MultipartRequestDescCase setDesc(ByteBuf input) {
        MultipartRequestDescCaseBuilder caseBuilder = new MultipartRequestDescCaseBuilder();
        MultipartRequestDescBuilder descBuilder = new MultipartRequestDescBuilder();
        descBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestDesc(descBuilder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestFlags getMultipartRequestFlags(int input) {
        Boolean _oFPMPFREQMORE = (input & 1) > 0;
        MultipartRequestFlags flag = new MultipartRequestFlags(_oFPMPFREQMORE);
        return flag;
    }

    private static MultipartType getMultipartType(int input) {
        return MultipartType.forValue((int)input);
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

