/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;

public class PacketInMessageFactory
implements OFDeserializer<PacketInMessage>,
DeserializerRegistryInjector {
    private static final byte PADDING_IN_PACKET_IN_HEADER = 2;
    private static final MessageCodeKey MATCH_KEY = new MessageCodeKey(4, 0, Match.class);
    private DeserializerRegistry registry;

    public PacketInMessage deserialize(ByteBuf rawMessage) {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTotalLen(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(PacketInReason.forValue((int)rawMessage.readUnsignedByte()));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        OFDeserializer matchDeserializer = (OFDeserializer)this.registry.getDeserializer(MATCH_KEY);
        builder.setMatch((Match)matchDeserializer.deserialize(rawMessage));
        rawMessage.skipBytes(2);
        builder.setData(rawMessage.readBytes(rawMessage.readableBytes()).array());
        return builder.build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

